/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip44;

import io.github.novacrypto.bip32.Index;
import io.github.novacrypto.bip44.Account;
import io.github.novacrypto.bip44.Purpose;

public final class CoinType {
    private final Purpose purpose;
    private final int coinType;
    private final String string;

    CoinType(Purpose purpose, int coinType) {
        if (Index.isHardened((int)coinType)) {
            throw new IllegalArgumentException();
        }
        this.purpose = purpose;
        this.coinType = coinType;
        this.string = String.format("%s/%d'", purpose, coinType);
    }

    public int getValue() {
        return this.coinType;
    }

    public Purpose getParent() {
        return this.purpose;
    }

    public String toString() {
        return this.string;
    }

    public Account account(int account) {
        return new Account(this, account);
    }
}

