/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip44;

import io.github.novacrypto.bip32.Index;
import io.github.novacrypto.bip32.derivation.Derivation;
import io.github.novacrypto.bip44.AddressIndexDerivation;
import io.github.novacrypto.bip44.AddressIndexFromAccountDerivation;
import io.github.novacrypto.bip44.Change;

public final class AddressIndex {
    public static final Derivation<AddressIndex> DERIVATION = new AddressIndexDerivation();
    public static final Derivation<AddressIndex> DERIVATION_FROM_ACCOUNT = new AddressIndexFromAccountDerivation();
    private final Change change;
    private final int addressIndex;
    private final String string;

    AddressIndex(Change change, int addressIndex) {
        if (Index.isHardened((int)addressIndex)) {
            throw new IllegalArgumentException();
        }
        this.change = change;
        this.addressIndex = addressIndex;
        this.string = String.format("%s/%d", change, addressIndex);
    }

    public int getValue() {
        return this.addressIndex;
    }

    public Change getParent() {
        return this.change;
    }

    public String toString() {
        return this.string;
    }
}

