/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip44;

import io.github.novacrypto.bip32.Index;
import io.github.novacrypto.bip32.derivation.Derivation;
import io.github.novacrypto.bip44.AccountDerivation;
import io.github.novacrypto.bip44.Change;
import io.github.novacrypto.bip44.CoinType;

public final class Account {
    public static final Derivation<Account> DERIVATION = new AccountDerivation();
    private final CoinType coinType;
    private final int account;
    private final String string;

    Account(CoinType coinType, int account) {
        if (Index.isHardened((int)account)) {
            throw new IllegalArgumentException();
        }
        this.coinType = coinType;
        this.account = account;
        this.string = String.format("%s/%d'", coinType, account);
    }

    public int getValue() {
        return this.account;
    }

    public CoinType getParent() {
        return this.coinType;
    }

    public String toString() {
        return this.string;
    }

    public Change external() {
        return new Change(this, 0);
    }

    public Change internal() {
        return new Change(this, 1);
    }
}

