/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip39;

import io.github.novacrypto.bip39.NFKDNormalizer;
import io.github.novacrypto.bip39.SeedCalculator;
import io.github.novacrypto.bip39.WordList;
import io.github.novacrypto.bip39.WordListMapNormalization;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public final class SeedCalculatorByWordListLookUp {
    private final SeedCalculator seedCalculator;
    private final Map<CharSequence, char[]> map = new HashMap<CharSequence, char[]>();
    private final NFKDNormalizer normalizer;

    SeedCalculatorByWordListLookUp(SeedCalculator seedCalculator, WordList wordList) {
        this.seedCalculator = seedCalculator;
        this.normalizer = new WordListMapNormalization(wordList);
        for (int i = 0; i < 2048; ++i) {
            String word = this.normalizer.normalize(wordList.getWord(i));
            this.map.put(word, word.toCharArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public byte[] calculateSeed(Collection<? extends CharSequence> mnemonic, String passphrase) {
        int words = mnemonic.size();
        char[][] chars = new char[words][];
        LinkedList<char[]> toClear = new LinkedList<char[]>();
        int count = 0;
        int wordIndex = 0;
        for (CharSequence charSequence : mnemonic) {
            char[] wordChars = this.map.get(this.normalizer.normalize(charSequence));
            if (wordChars == null) {
                wordChars = this.normalizer.normalize(charSequence).toCharArray();
                toClear.add(wordChars);
            }
            chars[wordIndex++] = wordChars;
            count += wordChars.length;
        }
        char[] mnemonicChars = new char[count += words - 1];
        try {
            boolean bl = false;
            for (int i = 0; i < chars.length; ++i) {
                void var9_11;
                System.arraycopy(chars[i], 0, mnemonicChars, (int)var9_11, chars[i].length);
                var9_11 += chars[i].length;
                if (i >= chars.length - 1) continue;
                mnemonicChars[var9_11++] = 32;
            }
            byte[] byArray = this.seedCalculator.calculateSeed(mnemonicChars, passphrase);
            return byArray;
        }
        finally {
            Arrays.fill(mnemonicChars, '\u0000');
            Arrays.fill((Object[])chars, null);
            for (char[] charsToClear : toClear) {
                Arrays.fill(charsToClear, '\u0000');
            }
        }
    }
}

