/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip39;

import io.github.novacrypto.bip39.PBKDF2WithHmacSHA512;
import io.github.novacrypto.toruntime.CheckedExceptionToRuntime;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public enum JavaxPBKDF2WithHmacSHA512 implements PBKDF2WithHmacSHA512
{
    INSTANCE;

    private SecretKeyFactory skf = JavaxPBKDF2WithHmacSHA512.getPbkdf2WithHmacSHA512();

    @Override
    public byte[] hash(char[] chars, byte[] salt) {
        PBEKeySpec spec = new PBEKeySpec(chars, salt, 2048, 512);
        byte[] encoded = this.generateSecretKey(spec).getEncoded();
        spec.clearPassword();
        return encoded;
    }

    private SecretKey generateSecretKey(final PBEKeySpec spec) {
        return (SecretKey)CheckedExceptionToRuntime.toRuntime((CheckedExceptionToRuntime.Func)new CheckedExceptionToRuntime.Func<SecretKey>(){

            public SecretKey run() throws Exception {
                return JavaxPBKDF2WithHmacSHA512.this.skf.generateSecret(spec);
            }
        });
    }

    private static SecretKeyFactory getPbkdf2WithHmacSHA512() {
        return (SecretKeyFactory)CheckedExceptionToRuntime.toRuntime((CheckedExceptionToRuntime.Func)new CheckedExceptionToRuntime.Func<SecretKeyFactory>(){

            public SecretKeyFactory run() throws Exception {
                return SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            }
        });
    }
}

