/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkUtils {
    private static final Logger log = LoggerFactory.getLogger(NetworkUtils.class);
    private static final Map<Long, String> INT_TO_IP_CACHE = new ConcurrentHashMap<Long, String>(1024);
    private static final Map<String, Integer> IP_TO_INT_CACHE = new ConcurrentHashMap<String, Integer>(1024);

    private NetworkUtils() {
    }

    public static String int2ip(long ip) {
        String cachedIp = INT_TO_IP_CACHE.get(ip);
        if (cachedIp != null) {
            return cachedIp;
        }
        StringBuilder sb = new StringBuilder(15);
        sb.append(ip >> 24 & 0xFFL).append('.').append(ip >> 16 & 0xFFL).append('.').append(ip >> 8 & 0xFFL).append('.').append(ip & 0xFFL);
        String result = sb.toString();
        INT_TO_IP_CACHE.put(ip, result);
        return result;
    }

    public static int ip2int(String ip) {
        if (ip == null || ip.isEmpty()) {
            throw new IllegalArgumentException("IP address cannot be null or empty");
        }
        Integer cachedInt = IP_TO_INT_CACHE.get(ip);
        if (cachedInt != null) {
            return cachedInt;
        }
        String[] octets = ip.split("\\.");
        if (octets.length != 4) {
            throw new IllegalArgumentException("Invalid IP address format: " + ip);
        }
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            int octet = Integer.parseInt(octets[i]);
            if (octet < 0 || octet > 255) {
                throw new IllegalArgumentException("Invalid IP address octet: " + octet);
            }
            result <<= 8;
            result |= octet & 0xFF;
        }
        IP_TO_INT_CACHE.put(ip, result);
        return result;
    }

    public static OS getOS() {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        if (os.contains("win")) {
            return arch.contains("aarch64") ? OS.WINDOWS_ARM : OS.WINDOWS;
        }
        if (os.contains("nix") || os.contains("nux") || os.contains("aix")) {
            return arch.contains("aarch64") || arch.contains("arm") ? OS.LINUX_ARM : OS.LINUX;
        }
        if (os.contains("mac")) {
            return arch.contains("aarch64") || arch.contains("arm") ? OS.MAC_ARM64 : OS.MAC;
        }
        return OS.UNKNOWN;
    }

    public static void disableNativeOutput(int verbosityLevel) {
    }

    public static void enableNativeOutput(int verbosityLevel) {
    }

    public static enum OS {
        WINDOWS,
        WINDOWS_ARM,
        LINUX,
        LINUX_ARM,
        MAC,
        MAC_ARM64,
        UNKNOWN;

    }
}

