/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ton.java.utils.ByteUtils;

public final class HashUtils {
    private static final Map<String, MessageDigest> MESSAGE_DIGEST_CACHE = new ConcurrentHashMap<String, MessageDigest>();

    private HashUtils() {
    }

    private static MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException {
        MessageDigest digest = MESSAGE_DIGEST_CACHE.get(algorithm);
        if (digest == null) {
            digest = MessageDigest.getInstance(algorithm);
            MESSAGE_DIGEST_CACHE.put(algorithm, digest);
        }
        digest.reset();
        return digest;
    }

    public static byte[] sha256AsArray(byte[] bytes) {
        if (bytes == null) {
            return new byte[0];
        }
        try {
            MessageDigest digest = HashUtils.getMessageDigest("SHA-256");
            return digest.digest(bytes);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String sha256(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        try {
            MessageDigest digest = HashUtils.getMessageDigest("SHA-256");
            byte[] hash = digest.digest(bytes);
            return ByteUtils.bytesToHex(hash);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String sha256(String base) {
        if (base == null) {
            return "";
        }
        try {
            MessageDigest digest = HashUtils.getMessageDigest("SHA-256");
            byte[] hash = digest.digest(base.getBytes(StandardCharsets.UTF_8));
            return ByteUtils.bytesToHex(hash);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String sha256(int[] bytes) {
        if (bytes == null) {
            return "";
        }
        byte[] converted = ByteUtils.unsignedBytesToSigned(bytes);
        return HashUtils.sha256(converted);
    }

    public static byte[] sha1AsArray(byte[] bytes) {
        if (bytes == null) {
            return new byte[0];
        }
        try {
            MessageDigest digest = HashUtils.getMessageDigest("SHA-1");
            return digest.digest(bytes);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String sha1(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        try {
            MessageDigest digest = HashUtils.getMessageDigest("SHA-1");
            byte[] hash = digest.digest(bytes);
            return ByteUtils.bytesToHex(hash);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] md5AsArray(byte[] bytes) {
        if (bytes == null) {
            return new byte[0];
        }
        try {
            MessageDigest digest = HashUtils.getMessageDigest("MD5");
            return digest.digest(bytes);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String md5(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        try {
            MessageDigest digest = HashUtils.getMessageDigest("MD5");
            byte[] hash = digest.digest(bytes);
            return ByteUtils.bytesToHex(hash);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static int getCRC16ChecksumAsInt(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return 0;
        }
        int crc = 0;
        int polynomial = 4129;
        for (byte b : bytes) {
            for (int i = 0; i < 8; ++i) {
                boolean bit = (b >> 7 - i & 1) == 1;
                boolean c15 = (crc >> 15 & 1) == 1;
                crc <<= 1;
                if (!(c15 ^ bit)) continue;
                crc ^= polynomial;
            }
        }
        return crc &= 0xFFFF;
    }

    public static byte[] getCRC16ChecksumAsBytes(byte[] bytes) {
        return ByteUtils.intToByteArray(HashUtils.getCRC16ChecksumAsInt(bytes));
    }

    public static String getCRC16ChecksumAsHex(byte[] bytes) {
        return ByteUtils.bytesToHex(HashUtils.getCRC16ChecksumAsBytes(bytes));
    }

    public static int calculateMethodId(String methodName) {
        int l = HashUtils.getCRC16ChecksumAsInt(methodName.getBytes(StandardCharsets.UTF_8));
        l = l & 0xFFFF | 0x10000;
        return l;
    }
}

