/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.utils;

import com.iwebpp.crypto.TweetNaclFast;
import java.math.BigInteger;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.LinkedList;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;
import org.ton.java.utils.ByteUtils;
import org.ton.java.utils.Secp256k1KeyPair;
import org.ton.java.utils.SignatureWithRecovery;

public final class CryptoUtils {
    private static final String RANDOM_NUMBER_ALGORITHM = "SHA1PRNG";
    private static final String RANDOM_NUMBER_ALGORITHM_PROVIDER = "SUN";
    private static final String SECP256K1 = "secp256k1";
    public static final BigInteger MAXPRIVATEKEY = new BigInteger("00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364140", 16);
    public static final byte[] HIGH_S = ByteUtils.hexToSignedBytes("7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF5D576E7357A4501DDFE92F46681B20A0");

    private CryptoUtils() {
    }

    public static TweetNaclFast.Signature.KeyPair generateSignatureKeyPair() {
        return TweetNaclFast.Signature.keyPair();
    }

    public static TweetNaclFast.Box.KeyPair generateKeyPair() {
        return TweetNaclFast.Box.keyPair();
    }

    public static TweetNaclFast.Signature.KeyPair generateSignatureKeyPairFromSeed(byte[] secretKey) {
        return TweetNaclFast.Signature.keyPair_fromSeed((byte[])secretKey);
    }

    public static TweetNaclFast.Box.KeyPair generateKeyPairFromSecretKey(byte[] secretKey) {
        return TweetNaclFast.Box.keyPair_fromSecretKey((byte[])secretKey);
    }

    public static TweetNaclFast.Signature getSignature(byte[] pubKey, byte[] prvKey) {
        TweetNaclFast.Signature signature;
        if (prvKey.length == 64) {
            signature = new TweetNaclFast.Signature(pubKey, prvKey);
        } else {
            TweetNaclFast.Signature.KeyPair keyPair = CryptoUtils.generateSignatureKeyPairFromSeed(prvKey);
            signature = new TweetNaclFast.Signature(pubKey, keyPair.getSecretKey());
        }
        return signature;
    }

    public static TweetNaclFast.Signature.KeyPair keyPairFromHex(String hex) {
        return CryptoUtils.generateSignatureKeyPairFromSeed(ByteUtils.hexToSignedBytes(hex));
    }

    public static byte[] signData(byte[] pubKey, byte[] prvKey, byte[] data) {
        return CryptoUtils.getSignature(pubKey, prvKey).detached(data);
    }

    public static Secp256k1KeyPair getSecp256k1FromPrivateKey(String privateKeyHex) {
        byte[] privateKey = ByteUtils.hexToSignedBytes(privateKeyHex);
        return Secp256k1KeyPair.builder().privateKey(privateKey).publicKey(CryptoUtils.getPublicKey(privateKey)).build();
    }

    public static Secp256k1KeyPair generateSecp256k1SignatureKeyPair() {
        byte[] privateKey = CryptoUtils.generatePrivateKey();
        return Secp256k1KeyPair.builder().privateKey(privateKey).publicKey(CryptoUtils.getPublicKey(privateKey)).build();
    }

    public static byte[] generatePrivateKey() {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance(RANDOM_NUMBER_ALGORITHM, RANDOM_NUMBER_ALGORITHM_PROVIDER);
            byte[] privateKeyAttempt = new byte[32];
            secureRandom.nextBytes(privateKeyAttempt);
            BigInteger privateKeyCheck = new BigInteger(1, privateKeyAttempt);
            while (privateKeyCheck.compareTo(BigInteger.ZERO) == 0 || privateKeyCheck.compareTo(MAXPRIVATEKEY) == 1) {
                secureRandom.nextBytes(privateKeyAttempt);
                privateKeyCheck = new BigInteger(1, privateKeyAttempt);
            }
            return privateKeyAttempt;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getPublicKey(byte[] privateKey) {
        try {
            ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)SECP256K1);
            ECPoint pointQ = spec.getG().multiply(new BigInteger(1, privateKey));
            return pointQ.getEncoded(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting public key", e);
        }
    }

    public static SignatureWithRecovery signDataSecp256k1(byte[] data, byte[] privateKey, byte[] publicKey) {
        return CryptoUtils.signDataSecp256k1Once(data, privateKey, publicKey);
    }

    private static SignatureWithRecovery signDataSecp256k1Once(byte[] data, byte[] privateKey, byte[] publicKey) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)SECP256K1);
            ECDSASigner ecdsaSigner = new ECDSASigner();
            ECDomainParameters domain = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN());
            ECPrivateKeyParameters privateKeyParms = new ECPrivateKeyParameters(new BigInteger(1, privateKey), domain);
            ParametersWithRandom params = new ParametersWithRandom((CipherParameters)privateKeyParms);
            ecdsaSigner.init(true, (CipherParameters)params);
            BigInteger[] sig = ecdsaSigner.generateSignature(data);
            byte[] rBytes = CryptoUtils.to32ByteArray(sig[0]);
            BigInteger highS = BigIntegers.fromUnsignedByteArray((byte[])HIGH_S);
            if (sig[1].compareTo(highS) >= 0) {
                sig[1] = domain.getN().subtract(sig[1]);
            }
            byte[] sBytes = CryptoUtils.to32ByteArray(sig[1]);
            LinkedList<byte[]> sigData = new LinkedList<byte[]>();
            byte recoveryId = CryptoUtils.getRecoveryId(rBytes, sBytes, data, publicKey);
            for (BigInteger sigChunk : sig) {
                sigData.add(CryptoUtils.to32ByteArray(sigChunk));
            }
            sigData.add(new byte[]{recoveryId});
            return SignatureWithRecovery.builder().r((byte[])sigData.get(0)).s((byte[])sigData.get(1)).v((byte[])sigData.get(2)).build();
        }
        catch (Exception e) {
            throw new Error("cannot sign, error " + e.getMessage());
        }
    }

    private static byte[] to32ByteArray(BigInteger value) {
        byte[] rawBytes = value.toByteArray();
        if (rawBytes.length == 33 && rawBytes[0] == 0) {
            byte[] trimmed = new byte[32];
            System.arraycopy(rawBytes, 1, trimmed, 0, 32);
            return trimmed;
        }
        if (rawBytes.length > 32) {
            throw new IllegalArgumentException("Value too large to fit in 32 bytes: " + value.toString(16));
        }
        if (rawBytes.length < 32) {
            byte[] padded = new byte[32];
            System.arraycopy(rawBytes, 0, padded, 32 - rawBytes.length, rawBytes.length);
            return padded;
        }
        return rawBytes;
    }

    public static byte getRecoveryId(byte[] sigR, byte[] sigS, byte[] message, byte[] publicKey) {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)SECP256K1);
        BigInteger pointN = spec.getN();
        for (int recoveryId = 0; recoveryId < 2; ++recoveryId) {
            try {
                BigInteger pointX = new BigInteger(1, sigR);
                X9IntegerConverter x9 = new X9IntegerConverter();
                byte[] compEnc = x9.integerToBytes(pointX, 1 + x9.getByteLength(spec.getCurve()));
                compEnc[0] = (byte)((recoveryId & 1) == 1 ? 3 : 2);
                ECPoint pointR = spec.getCurve().decodePoint(compEnc);
                if (!pointR.multiply(pointN).isInfinity()) continue;
                BigInteger pointE = new BigInteger(1, message);
                BigInteger pointEInv = BigInteger.ZERO.subtract(pointE).mod(pointN);
                BigInteger pointRInv = new BigInteger(1, sigR).modInverse(pointN);
                BigInteger srInv = pointRInv.multiply(new BigInteger(1, sigS)).mod(pointN);
                BigInteger pointEInvRInv = pointRInv.multiply(pointEInv).mod(pointN);
                ECPoint pointQ = ECAlgorithms.sumOfTwoMultiplies((ECPoint)spec.getG(), (BigInteger)pointEInvRInv, (ECPoint)pointR, (BigInteger)srInv);
                byte[] pointQBytes = pointQ.getEncoded(true);
                boolean matchedKeys = true;
                for (int j = 0; j < publicKey.length; ++j) {
                    if (pointQBytes[j] == publicKey[j]) continue;
                    matchedKeys = false;
                    break;
                }
                if (!matchedKeys) continue;
                return (byte)(0xFF & recoveryId);
            }
            catch (Exception e) {
                throw new Error("getRecoveryId unexpected exception", e);
            }
        }
        return -1;
    }

    public static byte[] recoverPublicKey(byte[] sigR, byte[] sigS, byte[] sigV, byte[] message) {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)SECP256K1);
        BigInteger pointN = spec.getN();
        try {
            BigInteger pointX = new BigInteger(1, sigR);
            X9IntegerConverter x9 = new X9IntegerConverter();
            byte[] compEnc = x9.integerToBytes(pointX, 1 + x9.getByteLength(spec.getCurve()));
            compEnc[0] = (byte)((sigV[0] & 1) == 1 ? 3 : 2);
            ECPoint pointR = spec.getCurve().decodePoint(compEnc);
            if (pointR.isInfinity()) {
                return new byte[0];
            }
            BigInteger pointE = new BigInteger(1, message);
            BigInteger pointEInv = BigInteger.ZERO.subtract(pointE).mod(pointN);
            BigInteger pointRInv = new BigInteger(1, sigR).modInverse(pointN);
            BigInteger srInv = pointRInv.multiply(new BigInteger(1, sigS)).mod(pointN);
            BigInteger pointEInvRInv = pointRInv.multiply(pointEInv).mod(pointN);
            ECPoint pointQ = ECAlgorithms.sumOfTwoMultiplies((ECPoint)spec.getG(), (BigInteger)pointEInvRInv, (ECPoint)pointR, (BigInteger)srInv);
            return pointQ.getEncoded(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Error recovering public key from message", e);
        }
    }
}

