/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.utils;

import org.ton.java.utils.ByteUtils;

public final class CRC16Utils {
    private CRC16Utils() {
    }

    public static int getCRC16ChecksumAsInt(byte[] bytes) {
        int crc = 0;
        int polynomial = 4129;
        for (byte b : bytes) {
            for (int i = 0; i < 8; ++i) {
                boolean bit = (b >> 7 - i & 1) == 1;
                boolean c15 = (crc >> 15 & 1) == 1;
                crc <<= 1;
                if (!(c15 ^ bit)) continue;
                crc ^= polynomial;
            }
        }
        return crc &= 0xFFFF;
    }

    public static int calculateMethodId(String methodName) {
        int l = CRC16Utils.getCRC16ChecksumAsInt(methodName.getBytes());
        l = l & 0xFFFF | 0x10000;
        return l;
    }

    public static String getCRC16ChecksumAsHex(byte[] bytes) {
        return ByteUtils.bytesToHex(CRC16Utils.getCRC16ChecksumAsBytes(bytes));
    }

    public static byte[] getCRC16ChecksumAsBytes(byte[] bytes) {
        return ByteUtils.intToByteArray(CRC16Utils.getCRC16ChecksumAsInt(bytes));
    }
}

