/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tonlib.types;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.binary.Hex;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellSlice;
import org.ton.java.tonlib.types.AccountAddressOnly;
import org.ton.java.tonlib.types.ExtraCurrency;
import org.ton.java.tonlib.types.MsgData;
import org.ton.java.utils.Utils;

public class RawMessage
implements Serializable {
    @SerializedName(value="@type")
    final String type = "raw.message";
    String hash;
    AccountAddressOnly source;
    AccountAddressOnly destination;
    String value;
    List<ExtraCurrency> extra_currencies;
    String fwd_fee;
    String ihr_fee;
    long created_lt;
    String body_hash;
    MsgData msg_data;

    public String getMessage() {
        if (Objects.nonNull(this.msg_data.getBody())) {
            return this.msg_data.getBody();
        }
        return Utils.base64ToString((String)this.msg_data.getText());
    }

    public byte[] getMessageBytes() {
        if (Objects.nonNull(this.msg_data.getBody())) {
            return Utils.base64ToString((String)this.msg_data.getBody()).getBytes();
        }
        return Utils.base64ToString((String)this.msg_data.getText()).getBytes();
    }

    public String getMessageHex() {
        if (Objects.nonNull(this.msg_data.getBody())) {
            return Hex.encodeHexString((byte[])Utils.base64ToString((String)this.msg_data.getBody()).getBytes());
        }
        return Hex.encodeHexString((byte[])Utils.base64ToString((String)this.msg_data.getText()).getBytes());
    }

    public String getComment() {
        if (Objects.nonNull(this.msg_data.getText())) {
            return CellSlice.beginParse((Cell)Cell.fromHex((String)Utils.base64ToHexString((String)this.msg_data.getText()))).loadSnakeString();
        }
        return "";
    }

    RawMessage(String hash, AccountAddressOnly source, AccountAddressOnly destination, String value, List<ExtraCurrency> extra_currencies, String fwd_fee, String ihr_fee, long created_lt, String body_hash, MsgData msg_data) {
        this.hash = hash;
        this.source = source;
        this.destination = destination;
        this.value = value;
        this.extra_currencies = extra_currencies;
        this.fwd_fee = fwd_fee;
        this.ihr_fee = ihr_fee;
        this.created_lt = created_lt;
        this.body_hash = body_hash;
        this.msg_data = msg_data;
    }

    public static RawMessageBuilder builder() {
        return new RawMessageBuilder();
    }

    public String getType() {
        return this.type;
    }

    public String getHash() {
        return this.hash;
    }

    public AccountAddressOnly getSource() {
        return this.source;
    }

    public AccountAddressOnly getDestination() {
        return this.destination;
    }

    public String getValue() {
        return this.value;
    }

    public List<ExtraCurrency> getExtra_currencies() {
        return this.extra_currencies;
    }

    public String getFwd_fee() {
        return this.fwd_fee;
    }

    public String getIhr_fee() {
        return this.ihr_fee;
    }

    public long getCreated_lt() {
        return this.created_lt;
    }

    public String getBody_hash() {
        return this.body_hash;
    }

    public MsgData getMsg_data() {
        return this.msg_data;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setSource(AccountAddressOnly source) {
        this.source = source;
    }

    public void setDestination(AccountAddressOnly destination) {
        this.destination = destination;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setExtra_currencies(List<ExtraCurrency> extra_currencies) {
        this.extra_currencies = extra_currencies;
    }

    public void setFwd_fee(String fwd_fee) {
        this.fwd_fee = fwd_fee;
    }

    public void setIhr_fee(String ihr_fee) {
        this.ihr_fee = ihr_fee;
    }

    public void setCreated_lt(long created_lt) {
        this.created_lt = created_lt;
    }

    public void setBody_hash(String body_hash) {
        this.body_hash = body_hash;
    }

    public void setMsg_data(MsgData msg_data) {
        this.msg_data = msg_data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawMessage)) {
            return false;
        }
        RawMessage other = (RawMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreated_lt() != other.getCreated_lt()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        AccountAddressOnly this$source = this.getSource();
        AccountAddressOnly other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        AccountAddressOnly this$destination = this.getDestination();
        AccountAddressOnly other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<ExtraCurrency> this$extra_currencies = this.getExtra_currencies();
        List<ExtraCurrency> other$extra_currencies = other.getExtra_currencies();
        if (this$extra_currencies == null ? other$extra_currencies != null : !((Object)this$extra_currencies).equals(other$extra_currencies)) {
            return false;
        }
        String this$fwd_fee = this.getFwd_fee();
        String other$fwd_fee = other.getFwd_fee();
        if (this$fwd_fee == null ? other$fwd_fee != null : !this$fwd_fee.equals(other$fwd_fee)) {
            return false;
        }
        String this$ihr_fee = this.getIhr_fee();
        String other$ihr_fee = other.getIhr_fee();
        if (this$ihr_fee == null ? other$ihr_fee != null : !this$ihr_fee.equals(other$ihr_fee)) {
            return false;
        }
        String this$body_hash = this.getBody_hash();
        String other$body_hash = other.getBody_hash();
        if (this$body_hash == null ? other$body_hash != null : !this$body_hash.equals(other$body_hash)) {
            return false;
        }
        MsgData this$msg_data = this.getMsg_data();
        MsgData other$msg_data = other.getMsg_data();
        return !(this$msg_data == null ? other$msg_data != null : !((Object)this$msg_data).equals(other$msg_data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $created_lt = this.getCreated_lt();
        result = result * 59 + (int)($created_lt >>> 32 ^ $created_lt);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        AccountAddressOnly $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        AccountAddressOnly $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<ExtraCurrency> $extra_currencies = this.getExtra_currencies();
        result = result * 59 + ($extra_currencies == null ? 43 : ((Object)$extra_currencies).hashCode());
        String $fwd_fee = this.getFwd_fee();
        result = result * 59 + ($fwd_fee == null ? 43 : $fwd_fee.hashCode());
        String $ihr_fee = this.getIhr_fee();
        result = result * 59 + ($ihr_fee == null ? 43 : $ihr_fee.hashCode());
        String $body_hash = this.getBody_hash();
        result = result * 59 + ($body_hash == null ? 43 : $body_hash.hashCode());
        MsgData $msg_data = this.getMsg_data();
        result = result * 59 + ($msg_data == null ? 43 : ((Object)$msg_data).hashCode());
        return result;
    }

    public String toString() {
        return "RawMessage(type=" + this.getType() + ", hash=" + this.getHash() + ", source=" + String.valueOf(this.getSource()) + ", destination=" + String.valueOf(this.getDestination()) + ", value=" + this.getValue() + ", extra_currencies=" + String.valueOf(this.getExtra_currencies()) + ", fwd_fee=" + this.getFwd_fee() + ", ihr_fee=" + this.getIhr_fee() + ", created_lt=" + this.getCreated_lt() + ", body_hash=" + this.getBody_hash() + ", msg_data=" + String.valueOf(this.getMsg_data()) + ")";
    }

    public static class RawMessageBuilder {
        private String hash;
        private AccountAddressOnly source;
        private AccountAddressOnly destination;
        private String value;
        private List<ExtraCurrency> extra_currencies;
        private String fwd_fee;
        private String ihr_fee;
        private long created_lt;
        private String body_hash;
        private MsgData msg_data;

        RawMessageBuilder() {
        }

        public RawMessageBuilder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public RawMessageBuilder source(AccountAddressOnly source) {
            this.source = source;
            return this;
        }

        public RawMessageBuilder destination(AccountAddressOnly destination) {
            this.destination = destination;
            return this;
        }

        public RawMessageBuilder value(String value) {
            this.value = value;
            return this;
        }

        public RawMessageBuilder extra_currencies(List<ExtraCurrency> extra_currencies) {
            this.extra_currencies = extra_currencies;
            return this;
        }

        public RawMessageBuilder fwd_fee(String fwd_fee) {
            this.fwd_fee = fwd_fee;
            return this;
        }

        public RawMessageBuilder ihr_fee(String ihr_fee) {
            this.ihr_fee = ihr_fee;
            return this;
        }

        public RawMessageBuilder created_lt(long created_lt) {
            this.created_lt = created_lt;
            return this;
        }

        public RawMessageBuilder body_hash(String body_hash) {
            this.body_hash = body_hash;
            return this;
        }

        public RawMessageBuilder msg_data(MsgData msg_data) {
            this.msg_data = msg_data;
            return this;
        }

        public RawMessage build() {
            return new RawMessage(this.hash, this.source, this.destination, this.value, this.extra_currencies, this.fwd_fee, this.ihr_fee, this.created_lt, this.body_hash, this.msg_data);
        }

        public String toString() {
            return "RawMessage.RawMessageBuilder(hash=" + this.hash + ", source=" + String.valueOf(this.source) + ", destination=" + String.valueOf(this.destination) + ", value=" + this.value + ", extra_currencies=" + String.valueOf(this.extra_currencies) + ", fwd_fee=" + this.fwd_fee + ", ihr_fee=" + this.ihr_fee + ", created_lt=" + this.created_lt + ", body_hash=" + this.body_hash + ", msg_data=" + String.valueOf(this.msg_data) + ")";
        }
    }
}

