/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.WcSplitMergeTimings;
import org.ton.java.tlb.WorkchainDescr;
import org.ton.java.tlb.WorkchainFormat;

public class WorkchainDescrV2
implements WorkchainDescr,
Serializable {
    int workchain;
    long enabledSince;
    int actualMinSplit;
    int minSplit;
    int maxSplit;
    boolean basic;
    boolean active;
    boolean acceptMsgs;
    int flags;
    BigInteger zeroStateRootHash;
    BigInteger zeroStateFileHash;
    long version;
    WorkchainFormat format;
    WcSplitMergeTimings wcSplitMergeTimings;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(167, 8).storeUint(this.enabledSince, 32).storeUint(this.actualMinSplit, 8).storeUint(this.minSplit, 8).storeUint(this.maxSplit, 8).storeBit(Boolean.valueOf(this.basic)).storeBit(Boolean.valueOf(this.active)).storeBit(Boolean.valueOf(this.acceptMsgs)).storeUint(this.flags, 13).storeUint(this.zeroStateRootHash, 256).storeUint(this.zeroStateFileHash, 256).storeUint(this.version, 32).storeCell(this.format.toCell(true)).storeCell(this.wcSplitMergeTimings.toCell()).endCell();
    }

    public static WorkchainDescrV2 deserialize(CellSlice cs) {
        WorkchainDescrV2 workchainDescrV2 = WorkchainDescrV2.builder().workchain(cs.loadUint(8).intValue()).enabledSince(cs.loadUint(32).intValue()).actualMinSplit(cs.loadUint(8).intValue()).minSplit(cs.loadUint(8).intValue()).maxSplit(cs.loadUint(8).intValue()).build();
        boolean basic = cs.loadBit();
        workchainDescrV2.setBasic(basic);
        workchainDescrV2.setActive(cs.loadBit());
        workchainDescrV2.setAcceptMsgs(cs.loadBit());
        workchainDescrV2.setZeroStateRootHash(cs.loadUint(256));
        workchainDescrV2.setZeroStateFileHash(cs.loadUint(256));
        workchainDescrV2.setVersion(cs.loadUint(32).intValue());
        workchainDescrV2.setFormat(WorkchainFormat.deserialize(cs, basic));
        workchainDescrV2.setWcSplitMergeTimings(WcSplitMergeTimings.deserialize(cs));
        return workchainDescrV2;
    }

    WorkchainDescrV2(int workchain, long enabledSince, int actualMinSplit, int minSplit, int maxSplit, boolean basic, boolean active, boolean acceptMsgs, int flags, BigInteger zeroStateRootHash, BigInteger zeroStateFileHash, long version, WorkchainFormat format, WcSplitMergeTimings wcSplitMergeTimings) {
        this.workchain = workchain;
        this.enabledSince = enabledSince;
        this.actualMinSplit = actualMinSplit;
        this.minSplit = minSplit;
        this.maxSplit = maxSplit;
        this.basic = basic;
        this.active = active;
        this.acceptMsgs = acceptMsgs;
        this.flags = flags;
        this.zeroStateRootHash = zeroStateRootHash;
        this.zeroStateFileHash = zeroStateFileHash;
        this.version = version;
        this.format = format;
        this.wcSplitMergeTimings = wcSplitMergeTimings;
    }

    public static WorkchainDescrV2Builder builder() {
        return new WorkchainDescrV2Builder();
    }

    public int getWorkchain() {
        return this.workchain;
    }

    public long getEnabledSince() {
        return this.enabledSince;
    }

    public int getActualMinSplit() {
        return this.actualMinSplit;
    }

    public int getMinSplit() {
        return this.minSplit;
    }

    public int getMaxSplit() {
        return this.maxSplit;
    }

    public boolean isBasic() {
        return this.basic;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isAcceptMsgs() {
        return this.acceptMsgs;
    }

    public int getFlags() {
        return this.flags;
    }

    public BigInteger getZeroStateRootHash() {
        return this.zeroStateRootHash;
    }

    public BigInteger getZeroStateFileHash() {
        return this.zeroStateFileHash;
    }

    public long getVersion() {
        return this.version;
    }

    public WorkchainFormat getFormat() {
        return this.format;
    }

    public WcSplitMergeTimings getWcSplitMergeTimings() {
        return this.wcSplitMergeTimings;
    }

    public void setWorkchain(int workchain) {
        this.workchain = workchain;
    }

    public void setEnabledSince(long enabledSince) {
        this.enabledSince = enabledSince;
    }

    public void setActualMinSplit(int actualMinSplit) {
        this.actualMinSplit = actualMinSplit;
    }

    public void setMinSplit(int minSplit) {
        this.minSplit = minSplit;
    }

    public void setMaxSplit(int maxSplit) {
        this.maxSplit = maxSplit;
    }

    public void setBasic(boolean basic) {
        this.basic = basic;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setAcceptMsgs(boolean acceptMsgs) {
        this.acceptMsgs = acceptMsgs;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setZeroStateRootHash(BigInteger zeroStateRootHash) {
        this.zeroStateRootHash = zeroStateRootHash;
    }

    public void setZeroStateFileHash(BigInteger zeroStateFileHash) {
        this.zeroStateFileHash = zeroStateFileHash;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setFormat(WorkchainFormat format) {
        this.format = format;
    }

    public void setWcSplitMergeTimings(WcSplitMergeTimings wcSplitMergeTimings) {
        this.wcSplitMergeTimings = wcSplitMergeTimings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkchainDescrV2)) {
            return false;
        }
        WorkchainDescrV2 other = (WorkchainDescrV2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWorkchain() != other.getWorkchain()) {
            return false;
        }
        if (this.getEnabledSince() != other.getEnabledSince()) {
            return false;
        }
        if (this.getActualMinSplit() != other.getActualMinSplit()) {
            return false;
        }
        if (this.getMinSplit() != other.getMinSplit()) {
            return false;
        }
        if (this.getMaxSplit() != other.getMaxSplit()) {
            return false;
        }
        if (this.isBasic() != other.isBasic()) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.isAcceptMsgs() != other.isAcceptMsgs()) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        BigInteger this$zeroStateRootHash = this.getZeroStateRootHash();
        BigInteger other$zeroStateRootHash = other.getZeroStateRootHash();
        if (this$zeroStateRootHash == null ? other$zeroStateRootHash != null : !((Object)this$zeroStateRootHash).equals(other$zeroStateRootHash)) {
            return false;
        }
        BigInteger this$zeroStateFileHash = this.getZeroStateFileHash();
        BigInteger other$zeroStateFileHash = other.getZeroStateFileHash();
        if (this$zeroStateFileHash == null ? other$zeroStateFileHash != null : !((Object)this$zeroStateFileHash).equals(other$zeroStateFileHash)) {
            return false;
        }
        WorkchainFormat this$format = this.getFormat();
        WorkchainFormat other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        WcSplitMergeTimings this$wcSplitMergeTimings = this.getWcSplitMergeTimings();
        WcSplitMergeTimings other$wcSplitMergeTimings = other.getWcSplitMergeTimings();
        return !(this$wcSplitMergeTimings == null ? other$wcSplitMergeTimings != null : !((Object)this$wcSplitMergeTimings).equals(other$wcSplitMergeTimings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkchainDescrV2;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWorkchain();
        long $enabledSince = this.getEnabledSince();
        result = result * 59 + (int)($enabledSince >>> 32 ^ $enabledSince);
        result = result * 59 + this.getActualMinSplit();
        result = result * 59 + this.getMinSplit();
        result = result * 59 + this.getMaxSplit();
        result = result * 59 + (this.isBasic() ? 79 : 97);
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + (this.isAcceptMsgs() ? 79 : 97);
        result = result * 59 + this.getFlags();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        BigInteger $zeroStateRootHash = this.getZeroStateRootHash();
        result = result * 59 + ($zeroStateRootHash == null ? 43 : ((Object)$zeroStateRootHash).hashCode());
        BigInteger $zeroStateFileHash = this.getZeroStateFileHash();
        result = result * 59 + ($zeroStateFileHash == null ? 43 : ((Object)$zeroStateFileHash).hashCode());
        WorkchainFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        WcSplitMergeTimings $wcSplitMergeTimings = this.getWcSplitMergeTimings();
        result = result * 59 + ($wcSplitMergeTimings == null ? 43 : ((Object)$wcSplitMergeTimings).hashCode());
        return result;
    }

    public String toString() {
        return "WorkchainDescrV2(workchain=" + this.getWorkchain() + ", enabledSince=" + this.getEnabledSince() + ", actualMinSplit=" + this.getActualMinSplit() + ", minSplit=" + this.getMinSplit() + ", maxSplit=" + this.getMaxSplit() + ", basic=" + this.isBasic() + ", active=" + this.isActive() + ", acceptMsgs=" + this.isAcceptMsgs() + ", flags=" + this.getFlags() + ", zeroStateRootHash=" + String.valueOf(this.getZeroStateRootHash()) + ", zeroStateFileHash=" + String.valueOf(this.getZeroStateFileHash()) + ", version=" + this.getVersion() + ", format=" + String.valueOf(this.getFormat()) + ", wcSplitMergeTimings=" + String.valueOf(this.getWcSplitMergeTimings()) + ")";
    }

    public static class WorkchainDescrV2Builder {
        private int workchain;
        private long enabledSince;
        private int actualMinSplit;
        private int minSplit;
        private int maxSplit;
        private boolean basic;
        private boolean active;
        private boolean acceptMsgs;
        private int flags;
        private BigInteger zeroStateRootHash;
        private BigInteger zeroStateFileHash;
        private long version;
        private WorkchainFormat format;
        private WcSplitMergeTimings wcSplitMergeTimings;

        WorkchainDescrV2Builder() {
        }

        public WorkchainDescrV2Builder workchain(int workchain) {
            this.workchain = workchain;
            return this;
        }

        public WorkchainDescrV2Builder enabledSince(long enabledSince) {
            this.enabledSince = enabledSince;
            return this;
        }

        public WorkchainDescrV2Builder actualMinSplit(int actualMinSplit) {
            this.actualMinSplit = actualMinSplit;
            return this;
        }

        public WorkchainDescrV2Builder minSplit(int minSplit) {
            this.minSplit = minSplit;
            return this;
        }

        public WorkchainDescrV2Builder maxSplit(int maxSplit) {
            this.maxSplit = maxSplit;
            return this;
        }

        public WorkchainDescrV2Builder basic(boolean basic) {
            this.basic = basic;
            return this;
        }

        public WorkchainDescrV2Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public WorkchainDescrV2Builder acceptMsgs(boolean acceptMsgs) {
            this.acceptMsgs = acceptMsgs;
            return this;
        }

        public WorkchainDescrV2Builder flags(int flags) {
            this.flags = flags;
            return this;
        }

        public WorkchainDescrV2Builder zeroStateRootHash(BigInteger zeroStateRootHash) {
            this.zeroStateRootHash = zeroStateRootHash;
            return this;
        }

        public WorkchainDescrV2Builder zeroStateFileHash(BigInteger zeroStateFileHash) {
            this.zeroStateFileHash = zeroStateFileHash;
            return this;
        }

        public WorkchainDescrV2Builder version(long version) {
            this.version = version;
            return this;
        }

        public WorkchainDescrV2Builder format(WorkchainFormat format) {
            this.format = format;
            return this;
        }

        public WorkchainDescrV2Builder wcSplitMergeTimings(WcSplitMergeTimings wcSplitMergeTimings) {
            this.wcSplitMergeTimings = wcSplitMergeTimings;
            return this;
        }

        public WorkchainDescrV2 build() {
            return new WorkchainDescrV2(this.workchain, this.enabledSince, this.actualMinSplit, this.minSplit, this.maxSplit, this.basic, this.active, this.acceptMsgs, this.flags, this.zeroStateRootHash, this.zeroStateFileHash, this.version, this.format, this.wcSplitMergeTimings);
        }

        public String toString() {
            return "WorkchainDescrV2.WorkchainDescrV2Builder(workchain=" + this.workchain + ", enabledSince=" + this.enabledSince + ", actualMinSplit=" + this.actualMinSplit + ", minSplit=" + this.minSplit + ", maxSplit=" + this.maxSplit + ", basic=" + this.basic + ", active=" + this.active + ", acceptMsgs=" + this.acceptMsgs + ", flags=" + this.flags + ", zeroStateRootHash=" + String.valueOf(this.zeroStateRootHash) + ", zeroStateFileHash=" + String.valueOf(this.zeroStateFileHash) + ", version=" + this.version + ", format=" + String.valueOf(this.format) + ", wcSplitMergeTimings=" + String.valueOf(this.wcSplitMergeTimings) + ")";
        }
    }
}

