/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.VmCont;

public class VmcPushInt
implements VmCont,
Serializable {
    long magic;
    BigInteger value;
    VmCont next;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(15, 4).storeInt(this.value, 32).storeRef(this.next.toCell()).endCell();
    }

    public static VmcPushInt deserialize(CellSlice cs) {
        return VmcPushInt.builder().magic(cs.loadUint(2).intValue()).next(VmCont.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).build();
    }

    VmcPushInt(long magic, BigInteger value, VmCont next) {
        this.magic = magic;
        this.value = value;
        this.next = next;
    }

    public static VmcPushIntBuilder builder() {
        return new VmcPushIntBuilder();
    }

    public long getMagic() {
        return this.magic;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public VmCont getNext() {
        return this.next;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public void setNext(VmCont next) {
        this.next = next;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmcPushInt)) {
            return false;
        }
        VmcPushInt other = (VmcPushInt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        BigInteger this$value = this.getValue();
        BigInteger other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        VmCont this$next = this.getNext();
        VmCont other$next = other.getNext();
        return !(this$next == null ? other$next != null : !this$next.equals(other$next));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmcPushInt;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        BigInteger $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        VmCont $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : $next.hashCode());
        return result;
    }

    public String toString() {
        return "VmcPushInt(magic=" + this.getMagic() + ", value=" + String.valueOf(this.getValue()) + ", next=" + String.valueOf(this.getNext()) + ")";
    }

    public static class VmcPushIntBuilder {
        private long magic;
        private BigInteger value;
        private VmCont next;

        VmcPushIntBuilder() {
        }

        public VmcPushIntBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public VmcPushIntBuilder value(BigInteger value) {
            this.value = value;
            return this;
        }

        public VmcPushIntBuilder next(VmCont next) {
            this.next = next;
            return this;
        }

        public VmcPushInt build() {
            return new VmcPushInt(this.magic, this.value, this.next);
        }

        public String toString() {
            return "VmcPushInt.VmcPushIntBuilder(magic=" + this.magic + ", value=" + String.valueOf(this.value) + ", next=" + String.valueOf(this.next) + ")";
        }
    }
}

