/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.VmStackValue;
import org.ton.java.tlb.VmTupleRef;

public class VmTuple
implements VmStackValue,
Serializable {
    List<VmStackValue> values;

    @Override
    public Cell toCell() {
        ArrayList<VmStackValue> pValues = new ArrayList<VmStackValue>(this.values);
        if (pValues.isEmpty()) {
            return CellBuilder.beginCell().endCell();
        }
        VmStackValue v = (VmStackValue)pValues.get(pValues.size() - 1);
        pValues.remove(pValues.size() - 1);
        return CellBuilder.beginCell().storeCell(VmTupleRef.toCellS(pValues)).storeRef(v.toCell()).endCell();
    }

    public static Cell toCell(List<VmTuple> pValues) {
        ArrayList<VmTuple> lValues = new ArrayList<VmTuple>(pValues);
        if (lValues.isEmpty()) {
            return CellBuilder.beginCell().endCell();
        }
        VmTuple v = (VmTuple)lValues.get(lValues.size() - 1);
        lValues.remove(lValues.size() - 1);
        return CellBuilder.beginCell().storeCell(VmTupleRef.toCell(lValues)).storeRef(v.toCell()).endCell();
    }

    public static Cell toCellS(List<VmStackValue> pValues) {
        ArrayList<VmStackValue> lValues = new ArrayList<VmStackValue>(pValues);
        if (lValues.isEmpty()) {
            return CellBuilder.beginCell().endCell();
        }
        VmStackValue v = (VmStackValue)lValues.get(lValues.size() - 1);
        lValues.remove(lValues.size() - 1);
        return CellBuilder.beginCell().storeCell(VmTupleRef.toCellS(lValues)).storeRef(v.toCell()).endCell();
    }

    public static VmTuple deserialize(CellSlice cs, int len) {
        if (len == 0) {
            return VmTuple.builder().values(Collections.emptyList()).build();
        }
        ArrayList<VmStackValue> ar = new ArrayList<VmStackValue>(VmTupleRef.deserialize(cs, len - 1).getValues());
        ar.add(cs.getRefsCount() > 0 ? VmStackValue.deserialize(CellSlice.beginParse((Cell)cs.loadRef())) : null);
        return VmTuple.builder().values(ar).build();
    }

    VmTuple(List<VmStackValue> values) {
        this.values = values;
    }

    public static VmTupleBuilder builder() {
        return new VmTupleBuilder();
    }

    public List<VmStackValue> getValues() {
        return this.values;
    }

    public void setValues(List<VmStackValue> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmTuple)) {
            return false;
        }
        VmTuple other = (VmTuple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<VmStackValue> this$values = this.getValues();
        List<VmStackValue> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmTuple;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<VmStackValue> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "VmTuple(values=" + String.valueOf(this.getValues()) + ")";
    }

    public static class VmTupleBuilder {
        private List<VmStackValue> values;

        VmTupleBuilder() {
        }

        public VmTupleBuilder values(List<VmStackValue> values) {
            this.values = values;
            return this;
        }

        public VmTuple build() {
            return new VmTuple(this.values);
        }

        public String toString() {
            return "VmTuple.VmTupleBuilder(values=" + String.valueOf(this.values) + ")";
        }
    }
}

