/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.VmStackValue;
import org.ton.java.tlb.VmTuple;

public class VmStackValueTuple
implements VmStackValue,
Serializable {
    int magic;
    int len;
    VmTuple data;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(7, 8).storeUint(this.data.getValues().size(), 16).storeCell(this.data.toCell()).endCell();
    }

    public static VmStackValueTuple deserialize(CellSlice cs) {
        int magic = cs.loadUint(8).intValue();
        int len = cs.loadUint(16).intValue();
        return VmStackValueTuple.builder().magic(magic).len(len).data(VmTuple.deserialize(cs, len)).build();
    }

    VmStackValueTuple(int magic, int len, VmTuple data) {
        this.magic = magic;
        this.len = len;
        this.data = data;
    }

    public static VmStackValueTupleBuilder builder() {
        return new VmStackValueTupleBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public int getLen() {
        return this.len;
    }

    public VmTuple getData() {
        return this.data;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public void setData(VmTuple data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmStackValueTuple)) {
            return false;
        }
        VmStackValueTuple other = (VmStackValueTuple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getLen() != other.getLen()) {
            return false;
        }
        VmTuple this$data = this.getData();
        VmTuple other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmStackValueTuple;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        result = result * 59 + this.getLen();
        VmTuple $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "VmStackValueTuple(magic=" + this.getMagic() + ", len=" + this.getLen() + ", data=" + String.valueOf(this.getData()) + ")";
    }

    public static class VmStackValueTupleBuilder {
        private int magic;
        private int len;
        private VmTuple data;

        VmStackValueTupleBuilder() {
        }

        public VmStackValueTupleBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public VmStackValueTupleBuilder len(int len) {
            this.len = len;
            return this;
        }

        public VmStackValueTupleBuilder data(VmTuple data) {
            this.data = data;
            return this;
        }

        public VmStackValueTuple build() {
            return new VmStackValueTuple(this.magic, this.len, this.data);
        }

        public String toString() {
            return "VmStackValueTuple.VmStackValueTupleBuilder(magic=" + this.magic + ", len=" + this.len + ", data=" + String.valueOf(this.data) + ")";
        }
    }
}

