/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.VmStackValue;

public class VmStackValueTinyInt
implements VmStackValue,
Serializable {
    long magic;
    BigInteger value;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(1, 8).storeInt(this.value, 64).endCell();
    }

    public static VmStackValueTinyInt deserialize(CellSlice cs) {
        return VmStackValueTinyInt.builder().magic(cs.loadUint(8).intValue()).value(cs.loadInt(64)).build();
    }

    VmStackValueTinyInt(long magic, BigInteger value) {
        this.magic = magic;
        this.value = value;
    }

    public static VmStackValueTinyIntBuilder builder() {
        return new VmStackValueTinyIntBuilder();
    }

    public long getMagic() {
        return this.magic;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmStackValueTinyInt)) {
            return false;
        }
        VmStackValueTinyInt other = (VmStackValueTinyInt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        BigInteger this$value = this.getValue();
        BigInteger other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmStackValueTinyInt;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        BigInteger $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    public String toString() {
        return "VmStackValueTinyInt(magic=" + this.getMagic() + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    public static class VmStackValueTinyIntBuilder {
        private long magic;
        private BigInteger value;

        VmStackValueTinyIntBuilder() {
        }

        public VmStackValueTinyIntBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public VmStackValueTinyIntBuilder value(BigInteger value) {
            this.value = value;
            return this;
        }

        public VmStackValueTinyInt build() {
            return new VmStackValueTinyInt(this.magic, this.value);
        }

        public String toString() {
            return "VmStackValueTinyInt.VmStackValueTinyIntBuilder(magic=" + this.magic + ", value=" + String.valueOf(this.value) + ")";
        }
    }
}

