/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.VmStackValue;

public class VmStackValueCell
implements VmStackValue,
Serializable {
    int magic;
    Cell cell;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(3, 8).storeRef(this.cell).endCell();
    }

    public static VmStackValueCell deserialize(CellSlice cs) {
        return VmStackValueCell.builder().magic(cs.loadUint(8).intValue()).cell(cs.loadRef()).build();
    }

    VmStackValueCell(int magic, Cell cell) {
        this.magic = magic;
        this.cell = cell;
    }

    public static VmStackValueCellBuilder builder() {
        return new VmStackValueCellBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public Cell getCell() {
        return this.cell;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setCell(Cell cell) {
        this.cell = cell;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmStackValueCell)) {
            return false;
        }
        VmStackValueCell other = (VmStackValueCell)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        Cell this$cell = this.getCell();
        Cell other$cell = other.getCell();
        return !(this$cell == null ? other$cell != null : !this$cell.equals(other$cell));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmStackValueCell;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        Cell $cell = this.getCell();
        result = result * 59 + ($cell == null ? 43 : $cell.hashCode());
        return result;
    }

    public String toString() {
        return "VmStackValueCell(magic=" + this.getMagic() + ", cell=" + String.valueOf(this.getCell()) + ")";
    }

    public static class VmStackValueCellBuilder {
        private int magic;
        private Cell cell;

        VmStackValueCellBuilder() {
        }

        public VmStackValueCellBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public VmStackValueCellBuilder cell(Cell cell) {
            this.cell = cell;
            return this;
        }

        public VmStackValueCell build() {
            return new VmStackValueCell(this.magic, this.cell);
        }

        public String toString() {
            return "VmStackValueCell.VmStackValueCellBuilder(magic=" + this.magic + ", cell=" + String.valueOf(this.cell) + ")";
        }
    }
}

