/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import org.ton.java.cell.Cell;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.VmStackValueBuilder;
import org.ton.java.tlb.VmStackValueCell;
import org.ton.java.tlb.VmStackValueCont;
import org.ton.java.tlb.VmStackValueInt;
import org.ton.java.tlb.VmStackValueNaN;
import org.ton.java.tlb.VmStackValueNull;
import org.ton.java.tlb.VmStackValueSlice;
import org.ton.java.tlb.VmStackValueTinyInt;
import org.ton.java.tlb.VmTuple;

public interface VmStackValue {
    public Cell toCell();

    public static VmStackValue deserialize(CellSlice cs) {
        if (cs.isSliceEmpty()) {
            return null;
        }
        int tag = cs.preloadUint(15).intValue();
        if (tag == 256) {
            return VmStackValueInt.deserialize(cs);
        }
        int magic = cs.preloadUint(8).intValue();
        if (magic == 0) {
            return VmStackValueNull.deserialize(cs);
        }
        if (magic == 1) {
            return VmStackValueTinyInt.deserialize(cs);
        }
        if (magic == 2) {
            int magic2 = cs.skipBits(8).preloadUint(7).intValue();
            if (magic2 == 0) {
                return VmStackValueInt.deserialize(cs);
            }
            cs.loadBit();
            return VmStackValueNaN.builder().build();
        }
        if (magic == 3) {
            return VmStackValueCell.deserialize(cs);
        }
        if (magic == 4) {
            return VmStackValueSlice.deserialize(cs);
        }
        if (magic == 5) {
            return VmStackValueBuilder.deserialize(cs);
        }
        if (magic == 6) {
            return VmStackValueCont.deserialize(cs);
        }
        if (magic == 7) {
            int len = cs.skipBits(8).loadUint(16).intValue();
            return VmTuple.deserialize(cs, len);
        }
        throw new Error("Error deserializing VmStackValue, wrong magic " + magic);
    }
}

