/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.VmSaveList;
import org.ton.java.tlb.VmStack;

public class VmControlData
implements Serializable {
    BigInteger nargs;
    VmStack stack;
    VmSaveList save;
    BigInteger cp;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUintMaybe(this.nargs, 13).storeCellMaybe(this.stack.toCell()).storeCell(this.save.toCell()).storeIntMaybe(this.cp, 16).endCell();
    }

    public static VmControlData deserialize(CellSlice cs) {
        return VmControlData.builder().nargs(cs.loadUintMaybe(13)).stack(cs.loadBit() ? VmStack.deserialize(cs) : null).save(VmSaveList.deserialize(cs)).cp(cs.loadIntMaybe(16)).build();
    }

    VmControlData(BigInteger nargs, VmStack stack, VmSaveList save, BigInteger cp) {
        this.nargs = nargs;
        this.stack = stack;
        this.save = save;
        this.cp = cp;
    }

    public static VmControlDataBuilder builder() {
        return new VmControlDataBuilder();
    }

    public BigInteger getNargs() {
        return this.nargs;
    }

    public VmStack getStack() {
        return this.stack;
    }

    public VmSaveList getSave() {
        return this.save;
    }

    public BigInteger getCp() {
        return this.cp;
    }

    public void setNargs(BigInteger nargs) {
        this.nargs = nargs;
    }

    public void setStack(VmStack stack) {
        this.stack = stack;
    }

    public void setSave(VmSaveList save) {
        this.save = save;
    }

    public void setCp(BigInteger cp) {
        this.cp = cp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmControlData)) {
            return false;
        }
        VmControlData other = (VmControlData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$nargs = this.getNargs();
        BigInteger other$nargs = other.getNargs();
        if (this$nargs == null ? other$nargs != null : !((Object)this$nargs).equals(other$nargs)) {
            return false;
        }
        VmStack this$stack = this.getStack();
        VmStack other$stack = other.getStack();
        if (this$stack == null ? other$stack != null : !((Object)this$stack).equals(other$stack)) {
            return false;
        }
        VmSaveList this$save = this.getSave();
        VmSaveList other$save = other.getSave();
        if (this$save == null ? other$save != null : !((Object)this$save).equals(other$save)) {
            return false;
        }
        BigInteger this$cp = this.getCp();
        BigInteger other$cp = other.getCp();
        return !(this$cp == null ? other$cp != null : !((Object)this$cp).equals(other$cp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmControlData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $nargs = this.getNargs();
        result = result * 59 + ($nargs == null ? 43 : ((Object)$nargs).hashCode());
        VmStack $stack = this.getStack();
        result = result * 59 + ($stack == null ? 43 : ((Object)$stack).hashCode());
        VmSaveList $save = this.getSave();
        result = result * 59 + ($save == null ? 43 : ((Object)$save).hashCode());
        BigInteger $cp = this.getCp();
        result = result * 59 + ($cp == null ? 43 : ((Object)$cp).hashCode());
        return result;
    }

    public String toString() {
        return "VmControlData(nargs=" + String.valueOf(this.getNargs()) + ", stack=" + String.valueOf(this.getStack()) + ", save=" + String.valueOf(this.getSave()) + ", cp=" + String.valueOf(this.getCp()) + ")";
    }

    public static class VmControlDataBuilder {
        private BigInteger nargs;
        private VmStack stack;
        private VmSaveList save;
        private BigInteger cp;

        VmControlDataBuilder() {
        }

        public VmControlDataBuilder nargs(BigInteger nargs) {
            this.nargs = nargs;
            return this;
        }

        public VmControlDataBuilder stack(VmStack stack) {
            this.stack = stack;
            return this;
        }

        public VmControlDataBuilder save(VmSaveList save) {
            this.save = save;
            return this;
        }

        public VmControlDataBuilder cp(BigInteger cp) {
            this.cp = cp;
            return this;
        }

        public VmControlData build() {
            return new VmControlData(this.nargs, this.stack, this.save, this.cp);
        }

        public String toString() {
            return "VmControlData.VmControlDataBuilder(nargs=" + String.valueOf(this.nargs) + ", stack=" + String.valueOf(this.stack) + ", save=" + String.valueOf(this.save) + ", cp=" + String.valueOf(this.cp) + ")";
        }
    }
}

