/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import org.ton.java.cell.Cell;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.VmcAgain;
import org.ton.java.tlb.VmcEnvelope;
import org.ton.java.tlb.VmcQuit;
import org.ton.java.tlb.VmcQuitExc;
import org.ton.java.tlb.VmcStd;
import org.ton.java.tlb.VmcUntil;
import org.ton.java.tlb.VmcWhileBody;
import org.ton.java.tlb.VmcWhileCond;

public interface VmCont {
    public Cell toCell();

    public static VmCont deserialize(CellSlice cs) {
        CellSlice c = cs.clone();
        int magic = c.preloadUint(2).intValue();
        if (magic == 0) {
            return VmcStd.deserialize(cs);
        }
        if (magic == 1) {
            return VmcEnvelope.deserialize(cs);
        }
        if (magic == 2) {
            int magic2 = c.skipBits(2).preloadUint(2).intValue();
            if (magic2 == 0) {
                return VmcQuit.deserialize(cs);
            }
            if (magic2 == 1) {
                return VmcQuitExc.deserialize(cs);
            }
            if (magic2 == 2) {
                return VmcQuitExc.deserialize(cs);
            }
            throw new Error("Error deserializing VmCont, wrong magic " + magic2);
        }
        if (magic == 3) {
            int magic2 = c.skipBits(2).preloadUint(4).intValue();
            if (magic2 == 0) {
                return VmcUntil.deserialize(cs);
            }
            if (magic2 == 1) {
                return VmcAgain.deserialize(cs);
            }
            if (magic2 == 2) {
                return VmcWhileCond.deserialize(cs);
            }
            if (magic2 == 3) {
                return VmcWhileBody.deserialize(cs);
            }
            throw new Error("Error deserializing VmCont, wrong magic " + magic2);
        }
        throw new Error("Error deserializing VmStackValue, wrong magic " + magic);
    }
}

