/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class VmCellSlice
implements Serializable {
    Cell cell;
    int stBits;
    int endBits;
    int stRef;
    int endRef;

    public Cell toCell() {
        return CellBuilder.beginCell().storeRef(this.cell).storeUint(this.stBits, 10).storeUint(this.endBits, 10).storeUint(this.stRef, 3).storeUint(this.endRef, 3).endCell();
    }

    public static VmCellSlice deserialize(CellSlice cs) {
        return VmCellSlice.builder().cell(cs.loadRef()).stBits(cs.loadUint(10).intValue()).endBits(cs.loadUint(10).intValue()).stRef(cs.loadUint(3).intValue()).endRef(cs.loadUint(3).intValue()).build();
    }

    VmCellSlice(Cell cell, int stBits, int endBits, int stRef, int endRef) {
        this.cell = cell;
        this.stBits = stBits;
        this.endBits = endBits;
        this.stRef = stRef;
        this.endRef = endRef;
    }

    public static VmCellSliceBuilder builder() {
        return new VmCellSliceBuilder();
    }

    public Cell getCell() {
        return this.cell;
    }

    public int getStBits() {
        return this.stBits;
    }

    public int getEndBits() {
        return this.endBits;
    }

    public int getStRef() {
        return this.stRef;
    }

    public int getEndRef() {
        return this.endRef;
    }

    public void setCell(Cell cell) {
        this.cell = cell;
    }

    public void setStBits(int stBits) {
        this.stBits = stBits;
    }

    public void setEndBits(int endBits) {
        this.endBits = endBits;
    }

    public void setStRef(int stRef) {
        this.stRef = stRef;
    }

    public void setEndRef(int endRef) {
        this.endRef = endRef;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmCellSlice)) {
            return false;
        }
        VmCellSlice other = (VmCellSlice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStBits() != other.getStBits()) {
            return false;
        }
        if (this.getEndBits() != other.getEndBits()) {
            return false;
        }
        if (this.getStRef() != other.getStRef()) {
            return false;
        }
        if (this.getEndRef() != other.getEndRef()) {
            return false;
        }
        Cell this$cell = this.getCell();
        Cell other$cell = other.getCell();
        return !(this$cell == null ? other$cell != null : !this$cell.equals(other$cell));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmCellSlice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStBits();
        result = result * 59 + this.getEndBits();
        result = result * 59 + this.getStRef();
        result = result * 59 + this.getEndRef();
        Cell $cell = this.getCell();
        result = result * 59 + ($cell == null ? 43 : $cell.hashCode());
        return result;
    }

    public String toString() {
        return "VmCellSlice(cell=" + String.valueOf(this.getCell()) + ", stBits=" + this.getStBits() + ", endBits=" + this.getEndBits() + ", stRef=" + this.getStRef() + ", endRef=" + this.getEndRef() + ")";
    }

    public static class VmCellSliceBuilder {
        private Cell cell;
        private int stBits;
        private int endBits;
        private int stRef;
        private int endRef;

        VmCellSliceBuilder() {
        }

        public VmCellSliceBuilder cell(Cell cell) {
            this.cell = cell;
            return this;
        }

        public VmCellSliceBuilder stBits(int stBits) {
            this.stBits = stBits;
            return this;
        }

        public VmCellSliceBuilder endBits(int endBits) {
            this.endBits = endBits;
            return this;
        }

        public VmCellSliceBuilder stRef(int stRef) {
            this.stRef = stRef;
            return this;
        }

        public VmCellSliceBuilder endRef(int endRef) {
            this.endRef = endRef;
            return this;
        }

        public VmCellSlice build() {
            return new VmCellSlice(this.cell, this.stBits, this.endBits, this.stRef, this.endRef);
        }

        public String toString() {
            return "VmCellSlice.VmCellSliceBuilder(cell=" + String.valueOf(this.cell) + ", stBits=" + this.stBits + ", endBits=" + this.endBits + ", stRef=" + this.stRef + ", endRef=" + this.endRef + ")";
        }
    }
}

