/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CurrencyCollection;

public class ValueFlow
implements Serializable {
    long magic;
    CurrencyCollection fromPrevBlk;
    CurrencyCollection toNextBlk;
    CurrencyCollection imported;
    CurrencyCollection exported;
    CurrencyCollection feesCollected;
    CurrencyCollection burned;
    CurrencyCollection feesImported;
    CurrencyCollection recovered;
    CurrencyCollection created;
    CurrencyCollection minted;

    private String getMagic() {
        return Long.toHexString(this.magic);
    }

    public Cell toCell() {
        Cell cell1 = CellBuilder.beginCell().storeCell(this.fromPrevBlk.toCell()).storeCell(this.toNextBlk.toCell()).storeCell(this.imported.toCell()).storeCell(this.exported.toCell()).endCell();
        Cell cell2 = CellBuilder.beginCell().storeCell(this.feesImported.toCell()).storeCell(this.recovered.toCell()).storeCell(this.created.toCell()).storeCell(this.minted.toCell()).endCell();
        return CellBuilder.beginCell().storeUint(3101986299L, 32).storeRef(cell1).storeCell(this.feesCollected.toCell()).storeRef(cell2).endCell();
    }

    public static ValueFlow deserialize(CellSlice cs) {
        long magic = cs.loadUint(32).longValue();
        if (magic == 3101986299L) {
            CellSlice c1 = CellSlice.beginParse((Cell)cs.loadRef());
            CellSlice c2 = CellSlice.beginParse((Cell)cs.loadRef());
            CurrencyCollection fromPrevBlk = CurrencyCollection.deserialize(c1);
            CurrencyCollection toNextBlk = CurrencyCollection.deserialize(c1);
            CurrencyCollection imported = CurrencyCollection.deserialize(c1);
            CurrencyCollection exported = CurrencyCollection.deserialize(c1);
            CurrencyCollection feesCollected = CurrencyCollection.deserialize(cs);
            CurrencyCollection feesImported = CurrencyCollection.deserialize(c2);
            CurrencyCollection recovered = CurrencyCollection.deserialize(c2);
            CurrencyCollection created = CurrencyCollection.deserialize(c2);
            CurrencyCollection minted = CurrencyCollection.deserialize(c2);
            return ValueFlow.builder().magic(3101986299L).fromPrevBlk(fromPrevBlk).toNextBlk(toNextBlk).imported(imported).exported(exported).feesCollected(feesCollected).feesImported(feesImported).recovered(recovered).created(created).minted(minted).build();
        }
        if (magic == 1052743863L) {
            CellSlice c1 = CellSlice.beginParse((Cell)cs.loadRef());
            CellSlice c2 = CellSlice.beginParse((Cell)cs.loadRef());
            CurrencyCollection fromPrevBlk = CurrencyCollection.deserialize(c1);
            CurrencyCollection toNextBlk = CurrencyCollection.deserialize(c1);
            CurrencyCollection imported = CurrencyCollection.deserialize(c1);
            CurrencyCollection exported = CurrencyCollection.deserialize(c1);
            CurrencyCollection feesCollected = CurrencyCollection.deserialize(cs);
            CurrencyCollection burned = CurrencyCollection.deserialize(cs);
            CurrencyCollection feesImported = CurrencyCollection.deserialize(c2);
            CurrencyCollection recovered = CurrencyCollection.deserialize(c2);
            CurrencyCollection created = CurrencyCollection.deserialize(c2);
            CurrencyCollection minted = CurrencyCollection.deserialize(c2);
            return ValueFlow.builder().magic(3101986299L).fromPrevBlk(fromPrevBlk).toNextBlk(toNextBlk).imported(imported).exported(exported).feesCollected(feesCollected).burned(burned).feesImported(feesImported).recovered(recovered).created(created).minted(minted).build();
        }
        throw new Error("ValueFlow: magic not equal to 0xb8e48dfb, found 0x" + Long.toHexString(magic));
    }

    ValueFlow(long magic, CurrencyCollection fromPrevBlk, CurrencyCollection toNextBlk, CurrencyCollection imported, CurrencyCollection exported, CurrencyCollection feesCollected, CurrencyCollection burned, CurrencyCollection feesImported, CurrencyCollection recovered, CurrencyCollection created, CurrencyCollection minted) {
        this.magic = magic;
        this.fromPrevBlk = fromPrevBlk;
        this.toNextBlk = toNextBlk;
        this.imported = imported;
        this.exported = exported;
        this.feesCollected = feesCollected;
        this.burned = burned;
        this.feesImported = feesImported;
        this.recovered = recovered;
        this.created = created;
        this.minted = minted;
    }

    public static ValueFlowBuilder builder() {
        return new ValueFlowBuilder();
    }

    public CurrencyCollection getFromPrevBlk() {
        return this.fromPrevBlk;
    }

    public CurrencyCollection getToNextBlk() {
        return this.toNextBlk;
    }

    public CurrencyCollection getImported() {
        return this.imported;
    }

    public CurrencyCollection getExported() {
        return this.exported;
    }

    public CurrencyCollection getFeesCollected() {
        return this.feesCollected;
    }

    public CurrencyCollection getBurned() {
        return this.burned;
    }

    public CurrencyCollection getFeesImported() {
        return this.feesImported;
    }

    public CurrencyCollection getRecovered() {
        return this.recovered;
    }

    public CurrencyCollection getCreated() {
        return this.created;
    }

    public CurrencyCollection getMinted() {
        return this.minted;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setFromPrevBlk(CurrencyCollection fromPrevBlk) {
        this.fromPrevBlk = fromPrevBlk;
    }

    public void setToNextBlk(CurrencyCollection toNextBlk) {
        this.toNextBlk = toNextBlk;
    }

    public void setImported(CurrencyCollection imported) {
        this.imported = imported;
    }

    public void setExported(CurrencyCollection exported) {
        this.exported = exported;
    }

    public void setFeesCollected(CurrencyCollection feesCollected) {
        this.feesCollected = feesCollected;
    }

    public void setBurned(CurrencyCollection burned) {
        this.burned = burned;
    }

    public void setFeesImported(CurrencyCollection feesImported) {
        this.feesImported = feesImported;
    }

    public void setRecovered(CurrencyCollection recovered) {
        this.recovered = recovered;
    }

    public void setCreated(CurrencyCollection created) {
        this.created = created;
    }

    public void setMinted(CurrencyCollection minted) {
        this.minted = minted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueFlow)) {
            return false;
        }
        ValueFlow other = (ValueFlow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        CurrencyCollection this$fromPrevBlk = this.getFromPrevBlk();
        CurrencyCollection other$fromPrevBlk = other.getFromPrevBlk();
        if (this$fromPrevBlk == null ? other$fromPrevBlk != null : !((Object)this$fromPrevBlk).equals(other$fromPrevBlk)) {
            return false;
        }
        CurrencyCollection this$toNextBlk = this.getToNextBlk();
        CurrencyCollection other$toNextBlk = other.getToNextBlk();
        if (this$toNextBlk == null ? other$toNextBlk != null : !((Object)this$toNextBlk).equals(other$toNextBlk)) {
            return false;
        }
        CurrencyCollection this$imported = this.getImported();
        CurrencyCollection other$imported = other.getImported();
        if (this$imported == null ? other$imported != null : !((Object)this$imported).equals(other$imported)) {
            return false;
        }
        CurrencyCollection this$exported = this.getExported();
        CurrencyCollection other$exported = other.getExported();
        if (this$exported == null ? other$exported != null : !((Object)this$exported).equals(other$exported)) {
            return false;
        }
        CurrencyCollection this$feesCollected = this.getFeesCollected();
        CurrencyCollection other$feesCollected = other.getFeesCollected();
        if (this$feesCollected == null ? other$feesCollected != null : !((Object)this$feesCollected).equals(other$feesCollected)) {
            return false;
        }
        CurrencyCollection this$burned = this.getBurned();
        CurrencyCollection other$burned = other.getBurned();
        if (this$burned == null ? other$burned != null : !((Object)this$burned).equals(other$burned)) {
            return false;
        }
        CurrencyCollection this$feesImported = this.getFeesImported();
        CurrencyCollection other$feesImported = other.getFeesImported();
        if (this$feesImported == null ? other$feesImported != null : !((Object)this$feesImported).equals(other$feesImported)) {
            return false;
        }
        CurrencyCollection this$recovered = this.getRecovered();
        CurrencyCollection other$recovered = other.getRecovered();
        if (this$recovered == null ? other$recovered != null : !((Object)this$recovered).equals(other$recovered)) {
            return false;
        }
        CurrencyCollection this$created = this.getCreated();
        CurrencyCollection other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        CurrencyCollection this$minted = this.getMinted();
        CurrencyCollection other$minted = other.getMinted();
        return !(this$minted == null ? other$minted != null : !((Object)this$minted).equals(other$minted));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValueFlow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        CurrencyCollection $fromPrevBlk = this.getFromPrevBlk();
        result = result * 59 + ($fromPrevBlk == null ? 43 : ((Object)$fromPrevBlk).hashCode());
        CurrencyCollection $toNextBlk = this.getToNextBlk();
        result = result * 59 + ($toNextBlk == null ? 43 : ((Object)$toNextBlk).hashCode());
        CurrencyCollection $imported = this.getImported();
        result = result * 59 + ($imported == null ? 43 : ((Object)$imported).hashCode());
        CurrencyCollection $exported = this.getExported();
        result = result * 59 + ($exported == null ? 43 : ((Object)$exported).hashCode());
        CurrencyCollection $feesCollected = this.getFeesCollected();
        result = result * 59 + ($feesCollected == null ? 43 : ((Object)$feesCollected).hashCode());
        CurrencyCollection $burned = this.getBurned();
        result = result * 59 + ($burned == null ? 43 : ((Object)$burned).hashCode());
        CurrencyCollection $feesImported = this.getFeesImported();
        result = result * 59 + ($feesImported == null ? 43 : ((Object)$feesImported).hashCode());
        CurrencyCollection $recovered = this.getRecovered();
        result = result * 59 + ($recovered == null ? 43 : ((Object)$recovered).hashCode());
        CurrencyCollection $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        CurrencyCollection $minted = this.getMinted();
        result = result * 59 + ($minted == null ? 43 : ((Object)$minted).hashCode());
        return result;
    }

    public String toString() {
        return "ValueFlow(magic=" + this.getMagic() + ", fromPrevBlk=" + String.valueOf(this.getFromPrevBlk()) + ", toNextBlk=" + String.valueOf(this.getToNextBlk()) + ", imported=" + String.valueOf(this.getImported()) + ", exported=" + String.valueOf(this.getExported()) + ", feesCollected=" + String.valueOf(this.getFeesCollected()) + ", burned=" + String.valueOf(this.getBurned()) + ", feesImported=" + String.valueOf(this.getFeesImported()) + ", recovered=" + String.valueOf(this.getRecovered()) + ", created=" + String.valueOf(this.getCreated()) + ", minted=" + String.valueOf(this.getMinted()) + ")";
    }

    public static class ValueFlowBuilder {
        private long magic;
        private CurrencyCollection fromPrevBlk;
        private CurrencyCollection toNextBlk;
        private CurrencyCollection imported;
        private CurrencyCollection exported;
        private CurrencyCollection feesCollected;
        private CurrencyCollection burned;
        private CurrencyCollection feesImported;
        private CurrencyCollection recovered;
        private CurrencyCollection created;
        private CurrencyCollection minted;

        ValueFlowBuilder() {
        }

        public ValueFlowBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public ValueFlowBuilder fromPrevBlk(CurrencyCollection fromPrevBlk) {
            this.fromPrevBlk = fromPrevBlk;
            return this;
        }

        public ValueFlowBuilder toNextBlk(CurrencyCollection toNextBlk) {
            this.toNextBlk = toNextBlk;
            return this;
        }

        public ValueFlowBuilder imported(CurrencyCollection imported) {
            this.imported = imported;
            return this;
        }

        public ValueFlowBuilder exported(CurrencyCollection exported) {
            this.exported = exported;
            return this;
        }

        public ValueFlowBuilder feesCollected(CurrencyCollection feesCollected) {
            this.feesCollected = feesCollected;
            return this;
        }

        public ValueFlowBuilder burned(CurrencyCollection burned) {
            this.burned = burned;
            return this;
        }

        public ValueFlowBuilder feesImported(CurrencyCollection feesImported) {
            this.feesImported = feesImported;
            return this;
        }

        public ValueFlowBuilder recovered(CurrencyCollection recovered) {
            this.recovered = recovered;
            return this;
        }

        public ValueFlowBuilder created(CurrencyCollection created) {
            this.created = created;
            return this;
        }

        public ValueFlowBuilder minted(CurrencyCollection minted) {
            this.minted = minted;
            return this;
        }

        public ValueFlow build() {
            return new ValueFlow(this.magic, this.fromPrevBlk, this.toNextBlk, this.imported, this.exported, this.feesCollected, this.burned, this.feesImported, this.recovered, this.created, this.minted);
        }

        public String toString() {
            return "ValueFlow.ValueFlowBuilder(magic=" + this.magic + ", fromPrevBlk=" + String.valueOf(this.fromPrevBlk) + ", toNextBlk=" + String.valueOf(this.toNextBlk) + ", imported=" + String.valueOf(this.imported) + ", exported=" + String.valueOf(this.exported) + ", feesCollected=" + String.valueOf(this.feesCollected) + ", burned=" + String.valueOf(this.burned) + ", feesImported=" + String.valueOf(this.feesImported) + ", recovered=" + String.valueOf(this.recovered) + ", created=" + String.valueOf(this.created) + ", minted=" + String.valueOf(this.minted) + ")";
        }
    }
}

