/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMap;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.tlb.ValidatorDescr;
import org.ton.java.tlb.ValidatorSet;
import org.ton.java.tlb.Validators;

public class ValidatorsExt
implements ValidatorSet {
    long magic;
    long uTimeSince;
    long uTimeUntil;
    int total;
    int main;
    BigInteger totalWeight;
    TonHashMapE list;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(18, 8).storeUint(this.uTimeSince, 32).storeUint(this.uTimeUntil, 32).storeUint(this.total, 16).storeUint(this.main, 16).storeUint(this.totalWeight, 64).storeDict(this.list.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 16).endCell().getBits(), v -> CellBuilder.beginCell().storeCell(((ValidatorDescr)v).toCell()).endCell())).endCell();
    }

    public static Validators deserialize(CellSlice cs) {
        return Validators.builder().magic(cs.loadUint(8).intValue()).uTimeSince(cs.loadUint(32).longValue()).uTimeUntil(cs.loadUint(32).longValue()).total(cs.loadUint(16).intValue()).main(cs.loadUint(16).intValue()).total(cs.loadUint(64).intValue()).list((TonHashMap)cs.loadDictE(16, k -> k.readUint(16), v -> ValidatorDescr.deserialize(CellSlice.beginParse((Cell)v)))).build();
    }

    public List<ValidatorDescr> getValidatorsAsList() {
        ArrayList<ValidatorDescr> validatorDescrs = new ArrayList<ValidatorDescr>();
        if (Objects.isNull(this.list)) {
            return validatorDescrs;
        }
        for (Map.Entry entry : this.list.elements.entrySet()) {
            validatorDescrs.add((ValidatorDescr)entry.getValue());
        }
        return validatorDescrs;
    }

    ValidatorsExt(long magic, long uTimeSince, long uTimeUntil, int total, int main, BigInteger totalWeight, TonHashMapE list) {
        this.magic = magic;
        this.uTimeSince = uTimeSince;
        this.uTimeUntil = uTimeUntil;
        this.total = total;
        this.main = main;
        this.totalWeight = totalWeight;
        this.list = list;
    }

    public static ValidatorsExtBuilder builder() {
        return new ValidatorsExtBuilder();
    }

    public long getMagic() {
        return this.magic;
    }

    public long getUTimeSince() {
        return this.uTimeSince;
    }

    public long getUTimeUntil() {
        return this.uTimeUntil;
    }

    public int getTotal() {
        return this.total;
    }

    public int getMain() {
        return this.main;
    }

    public BigInteger getTotalWeight() {
        return this.totalWeight;
    }

    public TonHashMapE getList() {
        return this.list;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setUTimeSince(long uTimeSince) {
        this.uTimeSince = uTimeSince;
    }

    public void setUTimeUntil(long uTimeUntil) {
        this.uTimeUntil = uTimeUntil;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void setMain(int main) {
        this.main = main;
    }

    public void setTotalWeight(BigInteger totalWeight) {
        this.totalWeight = totalWeight;
    }

    public void setList(TonHashMapE list) {
        this.list = list;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidatorsExt)) {
            return false;
        }
        ValidatorsExt other = (ValidatorsExt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getUTimeSince() != other.getUTimeSince()) {
            return false;
        }
        if (this.getUTimeUntil() != other.getUTimeUntil()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getMain() != other.getMain()) {
            return false;
        }
        BigInteger this$totalWeight = this.getTotalWeight();
        BigInteger other$totalWeight = other.getTotalWeight();
        if (this$totalWeight == null ? other$totalWeight != null : !((Object)this$totalWeight).equals(other$totalWeight)) {
            return false;
        }
        TonHashMapE this$list = this.getList();
        TonHashMapE other$list = other.getList();
        return !(this$list == null ? other$list != null : !this$list.equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidatorsExt;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        long $uTimeSince = this.getUTimeSince();
        result = result * 59 + (int)($uTimeSince >>> 32 ^ $uTimeSince);
        long $uTimeUntil = this.getUTimeUntil();
        result = result * 59 + (int)($uTimeUntil >>> 32 ^ $uTimeUntil);
        result = result * 59 + this.getTotal();
        result = result * 59 + this.getMain();
        BigInteger $totalWeight = this.getTotalWeight();
        result = result * 59 + ($totalWeight == null ? 43 : ((Object)$totalWeight).hashCode());
        TonHashMapE $list = this.getList();
        result = result * 59 + ($list == null ? 43 : $list.hashCode());
        return result;
    }

    public String toString() {
        return "ValidatorsExt(magic=" + this.getMagic() + ", uTimeSince=" + this.getUTimeSince() + ", uTimeUntil=" + this.getUTimeUntil() + ", total=" + this.getTotal() + ", main=" + this.getMain() + ", totalWeight=" + String.valueOf(this.getTotalWeight()) + ", list=" + String.valueOf(this.getList()) + ")";
    }

    public static class ValidatorsExtBuilder {
        private long magic;
        private long uTimeSince;
        private long uTimeUntil;
        private int total;
        private int main;
        private BigInteger totalWeight;
        private TonHashMapE list;

        ValidatorsExtBuilder() {
        }

        public ValidatorsExtBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public ValidatorsExtBuilder uTimeSince(long uTimeSince) {
            this.uTimeSince = uTimeSince;
            return this;
        }

        public ValidatorsExtBuilder uTimeUntil(long uTimeUntil) {
            this.uTimeUntil = uTimeUntil;
            return this;
        }

        public ValidatorsExtBuilder total(int total) {
            this.total = total;
            return this;
        }

        public ValidatorsExtBuilder main(int main) {
            this.main = main;
            return this;
        }

        public ValidatorsExtBuilder totalWeight(BigInteger totalWeight) {
            this.totalWeight = totalWeight;
            return this;
        }

        public ValidatorsExtBuilder list(TonHashMapE list) {
            this.list = list;
            return this;
        }

        public ValidatorsExt build() {
            return new ValidatorsExt(this.magic, this.uTimeSince, this.uTimeUntil, this.total, this.main, this.totalWeight, this.list);
        }

        public String toString() {
            return "ValidatorsExt.ValidatorsExtBuilder(magic=" + this.magic + ", uTimeSince=" + this.uTimeSince + ", uTimeUntil=" + this.uTimeUntil + ", total=" + this.total + ", main=" + this.main + ", totalWeight=" + String.valueOf(this.totalWeight) + ", list=" + String.valueOf(this.list) + ")";
        }
    }
}

