/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMap;
import org.ton.java.tlb.Validator;
import org.ton.java.tlb.ValidatorAddr;
import org.ton.java.tlb.ValidatorDescr;
import org.ton.java.tlb.ValidatorSet;

public class Validators
implements ValidatorSet {
    int magic;
    long uTimeSince;
    long uTimeUntil;
    int total;
    int main;
    TonHashMap list;

    private String getMagic() {
        return Long.toBinaryString(this.magic);
    }

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(17, 8).storeUint(this.uTimeSince, 32).storeUint(this.uTimeUntil, 32).storeUint(this.total, 16).storeUint(this.main, 16).storeDict(this.list.serialize(k -> CellBuilder.beginCell().storeUint(((Long)k).longValue(), 16).endCell().getBits(), v -> CellBuilder.beginCell().storeCell(((ValidatorDescr)v).toCell()).endCell())).endCell();
    }

    public static Validators deserialize(CellSlice cs) {
        return Validators.builder().magic(cs.loadUint(8).intValue()).uTimeSince(cs.loadUint(32).longValue()).uTimeUntil(cs.loadUint(32).longValue()).total(cs.loadUint(16).intValue()).main(cs.loadUint(16).intValue()).list(cs.loadDict(16, k -> k.readUint(16), v -> ValidatorDescr.deserialize(CellSlice.beginParse((Cell)v)))).build();
    }

    public List<Validator> getValidatorsAsList() {
        ArrayList<Validator> validators = new ArrayList<Validator>();
        if (Objects.isNull(this.list)) {
            return validators;
        }
        for (Map.Entry entry : this.list.elements.entrySet()) {
            validators.add((Validator)entry.getValue());
        }
        return validators;
    }

    public List<ValidatorAddr> getValidatorsAddrAsList() {
        ArrayList<ValidatorAddr> validatorAddrs = new ArrayList<ValidatorAddr>();
        if (Objects.isNull(this.list)) {
            return validatorAddrs;
        }
        for (Map.Entry entry : this.list.elements.entrySet()) {
            validatorAddrs.add((ValidatorAddr)entry.getValue());
        }
        return validatorAddrs;
    }

    Validators(int magic, long uTimeSince, long uTimeUntil, int total, int main, TonHashMap list) {
        this.magic = magic;
        this.uTimeSince = uTimeSince;
        this.uTimeUntil = uTimeUntil;
        this.total = total;
        this.main = main;
        this.list = list;
    }

    public static ValidatorsBuilder builder() {
        return new ValidatorsBuilder();
    }

    public long getUTimeSince() {
        return this.uTimeSince;
    }

    public long getUTimeUntil() {
        return this.uTimeUntil;
    }

    public int getTotal() {
        return this.total;
    }

    public int getMain() {
        return this.main;
    }

    public TonHashMap getList() {
        return this.list;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setUTimeSince(long uTimeSince) {
        this.uTimeSince = uTimeSince;
    }

    public void setUTimeUntil(long uTimeUntil) {
        this.uTimeUntil = uTimeUntil;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void setMain(int main) {
        this.main = main;
    }

    public void setList(TonHashMap list) {
        this.list = list;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Validators)) {
            return false;
        }
        Validators other = (Validators)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.getUTimeSince() != other.getUTimeSince()) {
            return false;
        }
        if (this.getUTimeUntil() != other.getUTimeUntil()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getMain() != other.getMain()) {
            return false;
        }
        TonHashMap this$list = this.getList();
        TonHashMap other$list = other.getList();
        return !(this$list == null ? other$list != null : !this$list.equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Validators;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        long $uTimeSince = this.getUTimeSince();
        result = result * 59 + (int)($uTimeSince >>> 32 ^ $uTimeSince);
        long $uTimeUntil = this.getUTimeUntil();
        result = result * 59 + (int)($uTimeUntil >>> 32 ^ $uTimeUntil);
        result = result * 59 + this.getTotal();
        result = result * 59 + this.getMain();
        TonHashMap $list = this.getList();
        result = result * 59 + ($list == null ? 43 : $list.hashCode());
        return result;
    }

    public String toString() {
        return "Validators(magic=" + this.getMagic() + ", uTimeSince=" + this.getUTimeSince() + ", uTimeUntil=" + this.getUTimeUntil() + ", total=" + this.getTotal() + ", main=" + this.getMain() + ", list=" + String.valueOf(this.getList()) + ")";
    }

    public static class ValidatorsBuilder {
        private int magic;
        private long uTimeSince;
        private long uTimeUntil;
        private int total;
        private int main;
        private TonHashMap list;

        ValidatorsBuilder() {
        }

        public ValidatorsBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public ValidatorsBuilder uTimeSince(long uTimeSince) {
            this.uTimeSince = uTimeSince;
            return this;
        }

        public ValidatorsBuilder uTimeUntil(long uTimeUntil) {
            this.uTimeUntil = uTimeUntil;
            return this;
        }

        public ValidatorsBuilder total(int total) {
            this.total = total;
            return this;
        }

        public ValidatorsBuilder main(int main) {
            this.main = main;
            return this;
        }

        public ValidatorsBuilder list(TonHashMap list) {
            this.list = list;
            return this;
        }

        public Validators build() {
            return new Validators(this.magic, this.uTimeSince, this.uTimeUntil, this.total, this.main, this.list);
        }

        public String toString() {
            return "Validators.ValidatorsBuilder(magic=" + this.magic + ", uTimeSince=" + this.uTimeSince + ", uTimeUntil=" + this.uTimeUntil + ", total=" + this.total + ", main=" + this.main + ", list=" + String.valueOf(this.list) + ")";
        }
    }
}

