/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CryptoSignature;
import org.ton.java.tlb.ValidatorTempKey;

public class ValidatorSignedTempKey
implements Serializable {
    int magic;
    ValidatorTempKey key;
    CryptoSignature signature;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(4, 4).storeRef(this.key.toCell()).storeCell(this.signature.toCell()).endCell();
    }

    public static ValidatorSignedTempKey deserialize(CellSlice cs) {
        return ValidatorSignedTempKey.builder().magic(cs.loadUint(4).intValue()).key(ValidatorTempKey.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).signature(CryptoSignature.deserialize(cs)).build();
    }

    ValidatorSignedTempKey(int magic, ValidatorTempKey key, CryptoSignature signature) {
        this.magic = magic;
        this.key = key;
        this.signature = signature;
    }

    public static ValidatorSignedTempKeyBuilder builder() {
        return new ValidatorSignedTempKeyBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public ValidatorTempKey getKey() {
        return this.key;
    }

    public CryptoSignature getSignature() {
        return this.signature;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setKey(ValidatorTempKey key) {
        this.key = key;
    }

    public void setSignature(CryptoSignature signature) {
        this.signature = signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidatorSignedTempKey)) {
            return false;
        }
        ValidatorSignedTempKey other = (ValidatorSignedTempKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        ValidatorTempKey this$key = this.getKey();
        ValidatorTempKey other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        CryptoSignature this$signature = this.getSignature();
        CryptoSignature other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidatorSignedTempKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        ValidatorTempKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        CryptoSignature $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        return result;
    }

    public String toString() {
        return "ValidatorSignedTempKey(magic=" + this.getMagic() + ", key=" + String.valueOf(this.getKey()) + ", signature=" + String.valueOf(this.getSignature()) + ")";
    }

    public static class ValidatorSignedTempKeyBuilder {
        private int magic;
        private ValidatorTempKey key;
        private CryptoSignature signature;

        ValidatorSignedTempKeyBuilder() {
        }

        public ValidatorSignedTempKeyBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public ValidatorSignedTempKeyBuilder key(ValidatorTempKey key) {
            this.key = key;
            return this;
        }

        public ValidatorSignedTempKeyBuilder signature(CryptoSignature signature) {
            this.signature = signature;
            return this;
        }

        public ValidatorSignedTempKey build() {
            return new ValidatorSignedTempKey(this.magic, this.key, this.signature);
        }

        public String toString() {
            return "ValidatorSignedTempKey.ValidatorSignedTempKeyBuilder(magic=" + this.magic + ", key=" + String.valueOf(this.key) + ", signature=" + String.valueOf(this.signature) + ")";
        }
    }
}

