/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class ValidatorBaseInfo
implements Serializable {
    int magic;
    long validatorListHashShort;
    long catchainSeqno;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.validatorListHashShort, 32).storeUint(this.catchainSeqno, 32).endCell();
    }

    public static ValidatorBaseInfo deserialize(CellSlice cs) {
        return ValidatorBaseInfo.builder().validatorListHashShort(cs.loadUint(32).longValue()).catchainSeqno(cs.loadUint(32).longValue()).build();
    }

    ValidatorBaseInfo(int magic, long validatorListHashShort, long catchainSeqno) {
        this.magic = magic;
        this.validatorListHashShort = validatorListHashShort;
        this.catchainSeqno = catchainSeqno;
    }

    public static ValidatorBaseInfoBuilder builder() {
        return new ValidatorBaseInfoBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public long getValidatorListHashShort() {
        return this.validatorListHashShort;
    }

    public long getCatchainSeqno() {
        return this.catchainSeqno;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setValidatorListHashShort(long validatorListHashShort) {
        this.validatorListHashShort = validatorListHashShort;
    }

    public void setCatchainSeqno(long catchainSeqno) {
        this.catchainSeqno = catchainSeqno;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidatorBaseInfo)) {
            return false;
        }
        ValidatorBaseInfo other = (ValidatorBaseInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getValidatorListHashShort() != other.getValidatorListHashShort()) {
            return false;
        }
        return this.getCatchainSeqno() == other.getCatchainSeqno();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidatorBaseInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        long $validatorListHashShort = this.getValidatorListHashShort();
        result = result * 59 + (int)($validatorListHashShort >>> 32 ^ $validatorListHashShort);
        long $catchainSeqno = this.getCatchainSeqno();
        result = result * 59 + (int)($catchainSeqno >>> 32 ^ $catchainSeqno);
        return result;
    }

    public String toString() {
        return "ValidatorBaseInfo(magic=" + this.getMagic() + ", validatorListHashShort=" + this.getValidatorListHashShort() + ", catchainSeqno=" + this.getCatchainSeqno() + ")";
    }

    public static class ValidatorBaseInfoBuilder {
        private int magic;
        private long validatorListHashShort;
        private long catchainSeqno;

        ValidatorBaseInfoBuilder() {
        }

        public ValidatorBaseInfoBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public ValidatorBaseInfoBuilder validatorListHashShort(long validatorListHashShort) {
            this.validatorListHashShort = validatorListHashShort;
            return this;
        }

        public ValidatorBaseInfoBuilder catchainSeqno(long catchainSeqno) {
            this.catchainSeqno = catchainSeqno;
            return this;
        }

        public ValidatorBaseInfo build() {
            return new ValidatorBaseInfo(this.magic, this.validatorListHashShort, this.catchainSeqno);
        }

        public String toString() {
            return "ValidatorBaseInfo.ValidatorBaseInfoBuilder(magic=" + this.magic + ", validatorListHashShort=" + this.validatorListHashShort + ", catchainSeqno=" + this.catchainSeqno + ")";
        }
    }
}

