/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.SigPubKey;
import org.ton.java.tlb.ValidatorAddr;
import org.ton.java.tlb.ValidatorDescr;

public class Validator
implements ValidatorDescr,
Serializable {
    long magic;
    SigPubKey publicKey;
    BigInteger weight;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(83, 8).storeCell(this.publicKey.toCell()).storeUint(this.weight, 64).endCell();
    }

    public static ValidatorAddr deserialize(CellSlice cs) {
        return ValidatorAddr.builder().magic(cs.loadUint(8).intValue()).publicKey(SigPubKey.deserialize(cs)).weight(cs.loadUint(64)).build();
    }

    @Override
    public String getPublicKeyHex() {
        return this.publicKey.getPubkey().toString(16);
    }

    @Override
    public String getAdnlAddressHex() {
        return "";
    }

    Validator(long magic, SigPubKey publicKey, BigInteger weight) {
        this.magic = magic;
        this.publicKey = publicKey;
        this.weight = weight;
    }

    public static ValidatorBuilder builder() {
        return new ValidatorBuilder();
    }

    public long getMagic() {
        return this.magic;
    }

    public SigPubKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public BigInteger getWeight() {
        return this.weight;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setPublicKey(SigPubKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setWeight(BigInteger weight) {
        this.weight = weight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Validator)) {
            return false;
        }
        Validator other = (Validator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        SigPubKey this$publicKey = this.getPublicKey();
        SigPubKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !((Object)this$publicKey).equals(other$publicKey)) {
            return false;
        }
        BigInteger this$weight = this.getWeight();
        BigInteger other$weight = other.getWeight();
        return !(this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Validator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        SigPubKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : ((Object)$publicKey).hashCode());
        BigInteger $weight = this.getWeight();
        result = result * 59 + ($weight == null ? 43 : ((Object)$weight).hashCode());
        return result;
    }

    public String toString() {
        return "Validator(magic=" + this.getMagic() + ", publicKey=" + String.valueOf(this.getPublicKey()) + ", weight=" + String.valueOf(this.getWeight()) + ")";
    }

    public static class ValidatorBuilder {
        private long magic;
        private SigPubKey publicKey;
        private BigInteger weight;

        ValidatorBuilder() {
        }

        public ValidatorBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public ValidatorBuilder publicKey(SigPubKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public ValidatorBuilder weight(BigInteger weight) {
            this.weight = weight;
            return this;
        }

        public Validator build() {
            return new Validator(this.magic, this.publicKey, this.weight);
        }

        public String toString() {
            return "Validator.ValidatorBuilder(magic=" + this.magic + ", publicKey=" + String.valueOf(this.publicKey) + ", weight=" + String.valueOf(this.weight) + ")";
        }
    }
}

