/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.tlb.Message;

public class TransactionIO
implements Serializable {
    Message in;
    TonHashMapE out;

    public Cell toCell() {
        Cell dictCell = this.out.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 15).endCell().getBits(), v -> CellBuilder.beginCell().storeRef(((Message)v).toCell()).endCell());
        return CellBuilder.beginCell().storeRefMaybe(this.in.toCell()).storeDict(dictCell).endCell();
    }

    public List<Message> getOutMessages() {
        ArrayList<Message> msgs = new ArrayList<Message>();
        for (Map.Entry entry : this.out.elements.entrySet()) {
            msgs.add((Message)entry.getValue());
        }
        return msgs;
    }

    TransactionIO(Message in, TonHashMapE out) {
        this.in = in;
        this.out = out;
    }

    public static TransactionIOBuilder builder() {
        return new TransactionIOBuilder();
    }

    public Message getIn() {
        return this.in;
    }

    public TonHashMapE getOut() {
        return this.out;
    }

    public void setIn(Message in) {
        this.in = in;
    }

    public void setOut(TonHashMapE out) {
        this.out = out;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionIO)) {
            return false;
        }
        TransactionIO other = (TransactionIO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Message this$in = this.getIn();
        Message other$in = other.getIn();
        if (this$in == null ? other$in != null : !((Object)this$in).equals(other$in)) {
            return false;
        }
        TonHashMapE this$out = this.getOut();
        TonHashMapE other$out = other.getOut();
        return !(this$out == null ? other$out != null : !this$out.equals(other$out));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionIO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Message $in = this.getIn();
        result = result * 59 + ($in == null ? 43 : ((Object)$in).hashCode());
        TonHashMapE $out = this.getOut();
        result = result * 59 + ($out == null ? 43 : $out.hashCode());
        return result;
    }

    public String toString() {
        return "TransactionIO(in=" + String.valueOf(this.getIn()) + ", out=" + String.valueOf(this.getOut()) + ")";
    }

    public static class TransactionIOBuilder {
        private Message in;
        private TonHashMapE out;

        TransactionIOBuilder() {
        }

        public TransactionIOBuilder in(Message in) {
            this.in = in;
            return this;
        }

        public TransactionIOBuilder out(TonHashMapE out) {
            this.out = out;
            return this;
        }

        public TransactionIO build() {
            return new TransactionIO(this.in, this.out);
        }

        public String toString() {
            return "TransactionIO.TransactionIOBuilder(in=" + String.valueOf(this.in) + ", out=" + String.valueOf(this.out) + ")";
        }
    }
}

