/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ActionPhase;
import org.ton.java.tlb.ComputePhase;
import org.ton.java.tlb.StoragePhase;
import org.ton.java.tlb.TransactionDescription;

public class TransactionDescriptionTickTock
implements TransactionDescription,
Serializable {
    int magic;
    boolean isTock;
    StoragePhase storagePhase;
    ComputePhase computePhase;
    ActionPhase actionPhase;
    boolean aborted;
    boolean destroyed;

    private String getMagic() {
        return Long.toBinaryString(this.magic);
    }

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(1, 3).storeBit(Boolean.valueOf(this.isTock)).storeCell(this.storagePhase.toCell()).storeCell(this.computePhase.toCell()).storeRefMaybe(this.actionPhase.toCell()).storeBit(Boolean.valueOf(this.aborted)).storeBit(Boolean.valueOf(this.destroyed)).endCell();
    }

    public static TransactionDescriptionTickTock deserialize(CellSlice cs) {
        long magic = cs.loadUint(3).intValue();
        assert (magic == 1L) : "TransactionDescriptionTickTock: magic not equal to 0b001, found 0x" + Long.toHexString(magic);
        return TransactionDescriptionTickTock.builder().magic(1).isTock(cs.loadBit()).storagePhase(StoragePhase.deserialize(cs)).computePhase(ComputePhase.deserialize(cs)).actionPhase(cs.loadBit() ? ActionPhase.deserialize(CellSlice.beginParse((Cell)cs.loadRef())) : null).aborted(cs.loadBit()).destroyed(cs.loadBit()).build();
    }

    @Override
    public String getType() {
        if (this.isTock) {
            return "tock";
        }
        return "tick";
    }

    TransactionDescriptionTickTock(int magic, boolean isTock, StoragePhase storagePhase, ComputePhase computePhase, ActionPhase actionPhase, boolean aborted, boolean destroyed) {
        this.magic = magic;
        this.isTock = isTock;
        this.storagePhase = storagePhase;
        this.computePhase = computePhase;
        this.actionPhase = actionPhase;
        this.aborted = aborted;
        this.destroyed = destroyed;
    }

    public static TransactionDescriptionTickTockBuilder builder() {
        return new TransactionDescriptionTickTockBuilder();
    }

    public boolean isTock() {
        return this.isTock;
    }

    public StoragePhase getStoragePhase() {
        return this.storagePhase;
    }

    public ComputePhase getComputePhase() {
        return this.computePhase;
    }

    public ActionPhase getActionPhase() {
        return this.actionPhase;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setTock(boolean isTock) {
        this.isTock = isTock;
    }

    public void setStoragePhase(StoragePhase storagePhase) {
        this.storagePhase = storagePhase;
    }

    public void setComputePhase(ComputePhase computePhase) {
        this.computePhase = computePhase;
    }

    public void setActionPhase(ActionPhase actionPhase) {
        this.actionPhase = actionPhase;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionDescriptionTickTock)) {
            return false;
        }
        TransactionDescriptionTickTock other = (TransactionDescriptionTickTock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.isTock() != other.isTock()) {
            return false;
        }
        if (this.isAborted() != other.isAborted()) {
            return false;
        }
        if (this.isDestroyed() != other.isDestroyed()) {
            return false;
        }
        StoragePhase this$storagePhase = this.getStoragePhase();
        StoragePhase other$storagePhase = other.getStoragePhase();
        if (this$storagePhase == null ? other$storagePhase != null : !((Object)this$storagePhase).equals(other$storagePhase)) {
            return false;
        }
        ComputePhase this$computePhase = this.getComputePhase();
        ComputePhase other$computePhase = other.getComputePhase();
        if (this$computePhase == null ? other$computePhase != null : !this$computePhase.equals(other$computePhase)) {
            return false;
        }
        ActionPhase this$actionPhase = this.getActionPhase();
        ActionPhase other$actionPhase = other.getActionPhase();
        return !(this$actionPhase == null ? other$actionPhase != null : !((Object)this$actionPhase).equals(other$actionPhase));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionDescriptionTickTock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        result = result * 59 + (this.isTock() ? 79 : 97);
        result = result * 59 + (this.isAborted() ? 79 : 97);
        result = result * 59 + (this.isDestroyed() ? 79 : 97);
        StoragePhase $storagePhase = this.getStoragePhase();
        result = result * 59 + ($storagePhase == null ? 43 : ((Object)$storagePhase).hashCode());
        ComputePhase $computePhase = this.getComputePhase();
        result = result * 59 + ($computePhase == null ? 43 : $computePhase.hashCode());
        ActionPhase $actionPhase = this.getActionPhase();
        result = result * 59 + ($actionPhase == null ? 43 : ((Object)$actionPhase).hashCode());
        return result;
    }

    public String toString() {
        return "TransactionDescriptionTickTock(magic=" + this.getMagic() + ", isTock=" + this.isTock() + ", storagePhase=" + String.valueOf(this.getStoragePhase()) + ", computePhase=" + String.valueOf(this.getComputePhase()) + ", actionPhase=" + String.valueOf(this.getActionPhase()) + ", aborted=" + this.isAborted() + ", destroyed=" + this.isDestroyed() + ")";
    }

    public static class TransactionDescriptionTickTockBuilder {
        private int magic;
        private boolean isTock;
        private StoragePhase storagePhase;
        private ComputePhase computePhase;
        private ActionPhase actionPhase;
        private boolean aborted;
        private boolean destroyed;

        TransactionDescriptionTickTockBuilder() {
        }

        public TransactionDescriptionTickTockBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public TransactionDescriptionTickTockBuilder isTock(boolean isTock) {
            this.isTock = isTock;
            return this;
        }

        public TransactionDescriptionTickTockBuilder storagePhase(StoragePhase storagePhase) {
            this.storagePhase = storagePhase;
            return this;
        }

        public TransactionDescriptionTickTockBuilder computePhase(ComputePhase computePhase) {
            this.computePhase = computePhase;
            return this;
        }

        public TransactionDescriptionTickTockBuilder actionPhase(ActionPhase actionPhase) {
            this.actionPhase = actionPhase;
            return this;
        }

        public TransactionDescriptionTickTockBuilder aborted(boolean aborted) {
            this.aborted = aborted;
            return this;
        }

        public TransactionDescriptionTickTockBuilder destroyed(boolean destroyed) {
            this.destroyed = destroyed;
            return this;
        }

        public TransactionDescriptionTickTock build() {
            return new TransactionDescriptionTickTock(this.magic, this.isTock, this.storagePhase, this.computePhase, this.actionPhase, this.aborted, this.destroyed);
        }

        public String toString() {
            return "TransactionDescriptionTickTock.TransactionDescriptionTickTockBuilder(magic=" + this.magic + ", isTock=" + this.isTock + ", storagePhase=" + String.valueOf(this.storagePhase) + ", computePhase=" + String.valueOf(this.computePhase) + ", actionPhase=" + String.valueOf(this.actionPhase) + ", aborted=" + this.aborted + ", destroyed=" + this.destroyed + ")";
        }
    }
}

