/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ActionPhase;
import org.ton.java.tlb.ComputePhase;
import org.ton.java.tlb.SplitMergeInfo;
import org.ton.java.tlb.StoragePhase;
import org.ton.java.tlb.TransactionDescription;

public class TransactionDescriptionSplitPrepare
implements TransactionDescription,
Serializable {
    int magic;
    SplitMergeInfo splitInfo;
    StoragePhase storagePhase;
    ComputePhase computePhase;
    ActionPhase actionPhase;
    boolean aborted;
    boolean destroyed;

    private String getMagic() {
        return Long.toBinaryString(this.magic);
    }

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(4, 4).storeCell(this.splitInfo.toCell()).storeCellMaybe(this.storagePhase.toCell()).storeCell(this.computePhase.toCell()).storeRefMaybe(this.actionPhase.toCell()).storeBit(Boolean.valueOf(this.aborted)).storeBit(Boolean.valueOf(this.destroyed)).endCell();
    }

    public static TransactionDescriptionSplitPrepare deserialize(CellSlice cs) {
        long magic = cs.loadUint(4).intValue();
        assert (magic == 4L) : "TransactionDescriptionSplitPrepare: magic not equal to 0b0100, found 0x" + Long.toHexString(magic);
        return TransactionDescriptionSplitPrepare.builder().magic(4).splitInfo(SplitMergeInfo.deserialize(cs)).storagePhase(cs.loadBit() ? StoragePhase.deserialize(cs) : null).computePhase(ComputePhase.deserialize(cs)).actionPhase(cs.loadBit() ? ActionPhase.deserialize(CellSlice.beginParse((Cell)cs.loadRef())) : null).aborted(cs.loadBit()).destroyed(cs.loadBit()).build();
    }

    @Override
    public String getType() {
        return "split-prepare";
    }

    TransactionDescriptionSplitPrepare(int magic, SplitMergeInfo splitInfo, StoragePhase storagePhase, ComputePhase computePhase, ActionPhase actionPhase, boolean aborted, boolean destroyed) {
        this.magic = magic;
        this.splitInfo = splitInfo;
        this.storagePhase = storagePhase;
        this.computePhase = computePhase;
        this.actionPhase = actionPhase;
        this.aborted = aborted;
        this.destroyed = destroyed;
    }

    public static TransactionDescriptionSplitPrepareBuilder builder() {
        return new TransactionDescriptionSplitPrepareBuilder();
    }

    public SplitMergeInfo getSplitInfo() {
        return this.splitInfo;
    }

    public StoragePhase getStoragePhase() {
        return this.storagePhase;
    }

    public ComputePhase getComputePhase() {
        return this.computePhase;
    }

    public ActionPhase getActionPhase() {
        return this.actionPhase;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setSplitInfo(SplitMergeInfo splitInfo) {
        this.splitInfo = splitInfo;
    }

    public void setStoragePhase(StoragePhase storagePhase) {
        this.storagePhase = storagePhase;
    }

    public void setComputePhase(ComputePhase computePhase) {
        this.computePhase = computePhase;
    }

    public void setActionPhase(ActionPhase actionPhase) {
        this.actionPhase = actionPhase;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionDescriptionSplitPrepare)) {
            return false;
        }
        TransactionDescriptionSplitPrepare other = (TransactionDescriptionSplitPrepare)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.isAborted() != other.isAborted()) {
            return false;
        }
        if (this.isDestroyed() != other.isDestroyed()) {
            return false;
        }
        SplitMergeInfo this$splitInfo = this.getSplitInfo();
        SplitMergeInfo other$splitInfo = other.getSplitInfo();
        if (this$splitInfo == null ? other$splitInfo != null : !((Object)this$splitInfo).equals(other$splitInfo)) {
            return false;
        }
        StoragePhase this$storagePhase = this.getStoragePhase();
        StoragePhase other$storagePhase = other.getStoragePhase();
        if (this$storagePhase == null ? other$storagePhase != null : !((Object)this$storagePhase).equals(other$storagePhase)) {
            return false;
        }
        ComputePhase this$computePhase = this.getComputePhase();
        ComputePhase other$computePhase = other.getComputePhase();
        if (this$computePhase == null ? other$computePhase != null : !this$computePhase.equals(other$computePhase)) {
            return false;
        }
        ActionPhase this$actionPhase = this.getActionPhase();
        ActionPhase other$actionPhase = other.getActionPhase();
        return !(this$actionPhase == null ? other$actionPhase != null : !((Object)this$actionPhase).equals(other$actionPhase));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionDescriptionSplitPrepare;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        result = result * 59 + (this.isAborted() ? 79 : 97);
        result = result * 59 + (this.isDestroyed() ? 79 : 97);
        SplitMergeInfo $splitInfo = this.getSplitInfo();
        result = result * 59 + ($splitInfo == null ? 43 : ((Object)$splitInfo).hashCode());
        StoragePhase $storagePhase = this.getStoragePhase();
        result = result * 59 + ($storagePhase == null ? 43 : ((Object)$storagePhase).hashCode());
        ComputePhase $computePhase = this.getComputePhase();
        result = result * 59 + ($computePhase == null ? 43 : $computePhase.hashCode());
        ActionPhase $actionPhase = this.getActionPhase();
        result = result * 59 + ($actionPhase == null ? 43 : ((Object)$actionPhase).hashCode());
        return result;
    }

    public String toString() {
        return "TransactionDescriptionSplitPrepare(magic=" + this.getMagic() + ", splitInfo=" + String.valueOf(this.getSplitInfo()) + ", storagePhase=" + String.valueOf(this.getStoragePhase()) + ", computePhase=" + String.valueOf(this.getComputePhase()) + ", actionPhase=" + String.valueOf(this.getActionPhase()) + ", aborted=" + this.isAborted() + ", destroyed=" + this.isDestroyed() + ")";
    }

    public static class TransactionDescriptionSplitPrepareBuilder {
        private int magic;
        private SplitMergeInfo splitInfo;
        private StoragePhase storagePhase;
        private ComputePhase computePhase;
        private ActionPhase actionPhase;
        private boolean aborted;
        private boolean destroyed;

        TransactionDescriptionSplitPrepareBuilder() {
        }

        public TransactionDescriptionSplitPrepareBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public TransactionDescriptionSplitPrepareBuilder splitInfo(SplitMergeInfo splitInfo) {
            this.splitInfo = splitInfo;
            return this;
        }

        public TransactionDescriptionSplitPrepareBuilder storagePhase(StoragePhase storagePhase) {
            this.storagePhase = storagePhase;
            return this;
        }

        public TransactionDescriptionSplitPrepareBuilder computePhase(ComputePhase computePhase) {
            this.computePhase = computePhase;
            return this;
        }

        public TransactionDescriptionSplitPrepareBuilder actionPhase(ActionPhase actionPhase) {
            this.actionPhase = actionPhase;
            return this;
        }

        public TransactionDescriptionSplitPrepareBuilder aborted(boolean aborted) {
            this.aborted = aborted;
            return this;
        }

        public TransactionDescriptionSplitPrepareBuilder destroyed(boolean destroyed) {
            this.destroyed = destroyed;
            return this;
        }

        public TransactionDescriptionSplitPrepare build() {
            return new TransactionDescriptionSplitPrepare(this.magic, this.splitInfo, this.storagePhase, this.computePhase, this.actionPhase, this.aborted, this.destroyed);
        }

        public String toString() {
            return "TransactionDescriptionSplitPrepare.TransactionDescriptionSplitPrepareBuilder(magic=" + this.magic + ", splitInfo=" + String.valueOf(this.splitInfo) + ", storagePhase=" + String.valueOf(this.storagePhase) + ", computePhase=" + String.valueOf(this.computePhase) + ", actionPhase=" + String.valueOf(this.actionPhase) + ", aborted=" + this.aborted + ", destroyed=" + this.destroyed + ")";
        }
    }
}

