/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.SplitMergeInfo;
import org.ton.java.tlb.Transaction;
import org.ton.java.tlb.TransactionDescription;

public class TransactionDescriptionSplitInstall
implements TransactionDescription,
Serializable {
    int magic;
    SplitMergeInfo splitInfo;
    Transaction prepareTransaction;
    boolean installed;

    private String getMagic() {
        return Long.toBinaryString(this.magic);
    }

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(5, 4).storeCell(this.splitInfo.toCell()).storeRef(this.prepareTransaction.toCell()).storeBit(Boolean.valueOf(this.installed)).endCell();
    }

    public static TransactionDescriptionSplitInstall deserialize(CellSlice cs) {
        long magic = cs.loadUint(4).intValue();
        assert (magic == 5L) : "TransactionDescriptionSplitInstall: magic not equal to 0b0101, found 0x" + Long.toHexString(magic);
        return TransactionDescriptionSplitInstall.builder().magic(5).splitInfo(SplitMergeInfo.deserialize(cs)).prepareTransaction(Transaction.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).installed(cs.loadBit()).build();
    }

    @Override
    public String getType() {
        return "split-install";
    }

    TransactionDescriptionSplitInstall(int magic, SplitMergeInfo splitInfo, Transaction prepareTransaction, boolean installed) {
        this.magic = magic;
        this.splitInfo = splitInfo;
        this.prepareTransaction = prepareTransaction;
        this.installed = installed;
    }

    public static TransactionDescriptionSplitInstallBuilder builder() {
        return new TransactionDescriptionSplitInstallBuilder();
    }

    public SplitMergeInfo getSplitInfo() {
        return this.splitInfo;
    }

    public Transaction getPrepareTransaction() {
        return this.prepareTransaction;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setSplitInfo(SplitMergeInfo splitInfo) {
        this.splitInfo = splitInfo;
    }

    public void setPrepareTransaction(Transaction prepareTransaction) {
        this.prepareTransaction = prepareTransaction;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionDescriptionSplitInstall)) {
            return false;
        }
        TransactionDescriptionSplitInstall other = (TransactionDescriptionSplitInstall)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.isInstalled() != other.isInstalled()) {
            return false;
        }
        SplitMergeInfo this$splitInfo = this.getSplitInfo();
        SplitMergeInfo other$splitInfo = other.getSplitInfo();
        if (this$splitInfo == null ? other$splitInfo != null : !((Object)this$splitInfo).equals(other$splitInfo)) {
            return false;
        }
        Transaction this$prepareTransaction = this.getPrepareTransaction();
        Transaction other$prepareTransaction = other.getPrepareTransaction();
        return !(this$prepareTransaction == null ? other$prepareTransaction != null : !((Object)this$prepareTransaction).equals(other$prepareTransaction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionDescriptionSplitInstall;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        result = result * 59 + (this.isInstalled() ? 79 : 97);
        SplitMergeInfo $splitInfo = this.getSplitInfo();
        result = result * 59 + ($splitInfo == null ? 43 : ((Object)$splitInfo).hashCode());
        Transaction $prepareTransaction = this.getPrepareTransaction();
        result = result * 59 + ($prepareTransaction == null ? 43 : ((Object)$prepareTransaction).hashCode());
        return result;
    }

    public String toString() {
        return "TransactionDescriptionSplitInstall(magic=" + this.getMagic() + ", splitInfo=" + String.valueOf(this.getSplitInfo()) + ", prepareTransaction=" + String.valueOf(this.getPrepareTransaction()) + ", installed=" + this.isInstalled() + ")";
    }

    public static class TransactionDescriptionSplitInstallBuilder {
        private int magic;
        private SplitMergeInfo splitInfo;
        private Transaction prepareTransaction;
        private boolean installed;

        TransactionDescriptionSplitInstallBuilder() {
        }

        public TransactionDescriptionSplitInstallBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public TransactionDescriptionSplitInstallBuilder splitInfo(SplitMergeInfo splitInfo) {
            this.splitInfo = splitInfo;
            return this;
        }

        public TransactionDescriptionSplitInstallBuilder prepareTransaction(Transaction prepareTransaction) {
            this.prepareTransaction = prepareTransaction;
            return this;
        }

        public TransactionDescriptionSplitInstallBuilder installed(boolean installed) {
            this.installed = installed;
            return this;
        }

        public TransactionDescriptionSplitInstall build() {
            return new TransactionDescriptionSplitInstall(this.magic, this.splitInfo, this.prepareTransaction, this.installed);
        }

        public String toString() {
            return "TransactionDescriptionSplitInstall.TransactionDescriptionSplitInstallBuilder(magic=" + this.magic + ", splitInfo=" + String.valueOf(this.splitInfo) + ", prepareTransaction=" + String.valueOf(this.prepareTransaction) + ", installed=" + this.installed + ")";
        }
    }
}

