/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.SplitMergeInfo;
import org.ton.java.tlb.StoragePhase;
import org.ton.java.tlb.TransactionDescription;

public class TransactionDescriptionMergePrepare
implements TransactionDescription,
Serializable {
    int magic;
    SplitMergeInfo splitInfo;
    StoragePhase storagePhase;
    boolean aborted;

    private String getMagic() {
        return Long.toBinaryString(this.magic);
    }

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(4, 4).storeCell(this.splitInfo.toCell()).storeCellMaybe(this.storagePhase.toCell()).storeBit(Boolean.valueOf(this.aborted)).endCell();
    }

    public static TransactionDescriptionMergePrepare deserialize(CellSlice cs) {
        long magic = cs.loadUint(4).intValue();
        assert (magic == 6L) : "TransactionDescriptionMergePrepare: magic not equal to 0b0110, found 0x" + Long.toHexString(magic);
        return TransactionDescriptionMergePrepare.builder().magic(6).splitInfo(SplitMergeInfo.deserialize(cs)).storagePhase(StoragePhase.deserialize(cs)).aborted(cs.loadBit()).build();
    }

    @Override
    public String getType() {
        return "merge-prepare";
    }

    TransactionDescriptionMergePrepare(int magic, SplitMergeInfo splitInfo, StoragePhase storagePhase, boolean aborted) {
        this.magic = magic;
        this.splitInfo = splitInfo;
        this.storagePhase = storagePhase;
        this.aborted = aborted;
    }

    public static TransactionDescriptionMergePrepareBuilder builder() {
        return new TransactionDescriptionMergePrepareBuilder();
    }

    public SplitMergeInfo getSplitInfo() {
        return this.splitInfo;
    }

    public StoragePhase getStoragePhase() {
        return this.storagePhase;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setSplitInfo(SplitMergeInfo splitInfo) {
        this.splitInfo = splitInfo;
    }

    public void setStoragePhase(StoragePhase storagePhase) {
        this.storagePhase = storagePhase;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionDescriptionMergePrepare)) {
            return false;
        }
        TransactionDescriptionMergePrepare other = (TransactionDescriptionMergePrepare)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.isAborted() != other.isAborted()) {
            return false;
        }
        SplitMergeInfo this$splitInfo = this.getSplitInfo();
        SplitMergeInfo other$splitInfo = other.getSplitInfo();
        if (this$splitInfo == null ? other$splitInfo != null : !((Object)this$splitInfo).equals(other$splitInfo)) {
            return false;
        }
        StoragePhase this$storagePhase = this.getStoragePhase();
        StoragePhase other$storagePhase = other.getStoragePhase();
        return !(this$storagePhase == null ? other$storagePhase != null : !((Object)this$storagePhase).equals(other$storagePhase));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionDescriptionMergePrepare;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        result = result * 59 + (this.isAborted() ? 79 : 97);
        SplitMergeInfo $splitInfo = this.getSplitInfo();
        result = result * 59 + ($splitInfo == null ? 43 : ((Object)$splitInfo).hashCode());
        StoragePhase $storagePhase = this.getStoragePhase();
        result = result * 59 + ($storagePhase == null ? 43 : ((Object)$storagePhase).hashCode());
        return result;
    }

    public String toString() {
        return "TransactionDescriptionMergePrepare(magic=" + this.getMagic() + ", splitInfo=" + String.valueOf(this.getSplitInfo()) + ", storagePhase=" + String.valueOf(this.getStoragePhase()) + ", aborted=" + this.isAborted() + ")";
    }

    public static class TransactionDescriptionMergePrepareBuilder {
        private int magic;
        private SplitMergeInfo splitInfo;
        private StoragePhase storagePhase;
        private boolean aborted;

        TransactionDescriptionMergePrepareBuilder() {
        }

        public TransactionDescriptionMergePrepareBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public TransactionDescriptionMergePrepareBuilder splitInfo(SplitMergeInfo splitInfo) {
            this.splitInfo = splitInfo;
            return this;
        }

        public TransactionDescriptionMergePrepareBuilder storagePhase(StoragePhase storagePhase) {
            this.storagePhase = storagePhase;
            return this;
        }

        public TransactionDescriptionMergePrepareBuilder aborted(boolean aborted) {
            this.aborted = aborted;
            return this;
        }

        public TransactionDescriptionMergePrepare build() {
            return new TransactionDescriptionMergePrepare(this.magic, this.splitInfo, this.storagePhase, this.aborted);
        }

        public String toString() {
            return "TransactionDescriptionMergePrepare.TransactionDescriptionMergePrepareBuilder(magic=" + this.magic + ", splitInfo=" + String.valueOf(this.splitInfo) + ", storagePhase=" + String.valueOf(this.storagePhase) + ", aborted=" + this.aborted + ")";
        }
    }
}

