/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ActionPhase;
import org.ton.java.tlb.ComputePhase;
import org.ton.java.tlb.CreditPhase;
import org.ton.java.tlb.SplitMergeInfo;
import org.ton.java.tlb.StoragePhase;
import org.ton.java.tlb.Transaction;
import org.ton.java.tlb.TransactionDescription;

public class TransactionDescriptionMergeInstall
implements TransactionDescription,
Serializable {
    int magic;
    SplitMergeInfo splitInfo;
    Transaction prepareTransaction;
    StoragePhase storagePhase;
    CreditPhase creditPhase;
    ComputePhase computePhase;
    ActionPhase actionPhase;
    boolean aborted;
    boolean destroyed;

    private String getMagic() {
        return Long.toBinaryString(this.magic);
    }

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(7, 4).storeCell(this.splitInfo.toCell()).storeRef(this.prepareTransaction.toCell()).storeCellMaybe(this.storagePhase.toCell()).storeCellMaybe(this.creditPhase.toCell()).storeCell(this.computePhase.toCell()).storeRefMaybe(this.actionPhase.toCell()).storeBit(Boolean.valueOf(this.aborted)).storeBit(Boolean.valueOf(this.destroyed)).endCell();
    }

    public static TransactionDescriptionMergeInstall deserialize(CellSlice cs) {
        long magic = cs.loadUint(4).intValue();
        assert (magic == 7L) : "TransactionDescriptionMergeInstall: magic not equal to 0b0111, found 0x" + Long.toHexString(magic);
        return TransactionDescriptionMergeInstall.builder().magic(7).splitInfo(SplitMergeInfo.deserialize(cs)).prepareTransaction(Transaction.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).storagePhase(cs.loadBit() ? StoragePhase.deserialize(cs) : null).creditPhase(cs.loadBit() ? CreditPhase.deserialize(cs) : null).computePhase(ComputePhase.deserialize(cs)).actionPhase(cs.loadBit() ? ActionPhase.deserialize(CellSlice.beginParse((Cell)cs.loadRef())) : null).aborted(cs.loadBit()).destroyed(cs.loadBit()).build();
    }

    @Override
    public String getType() {
        return "merge-install";
    }

    TransactionDescriptionMergeInstall(int magic, SplitMergeInfo splitInfo, Transaction prepareTransaction, StoragePhase storagePhase, CreditPhase creditPhase, ComputePhase computePhase, ActionPhase actionPhase, boolean aborted, boolean destroyed) {
        this.magic = magic;
        this.splitInfo = splitInfo;
        this.prepareTransaction = prepareTransaction;
        this.storagePhase = storagePhase;
        this.creditPhase = creditPhase;
        this.computePhase = computePhase;
        this.actionPhase = actionPhase;
        this.aborted = aborted;
        this.destroyed = destroyed;
    }

    public static TransactionDescriptionMergeInstallBuilder builder() {
        return new TransactionDescriptionMergeInstallBuilder();
    }

    public SplitMergeInfo getSplitInfo() {
        return this.splitInfo;
    }

    public Transaction getPrepareTransaction() {
        return this.prepareTransaction;
    }

    public StoragePhase getStoragePhase() {
        return this.storagePhase;
    }

    public CreditPhase getCreditPhase() {
        return this.creditPhase;
    }

    public ComputePhase getComputePhase() {
        return this.computePhase;
    }

    public ActionPhase getActionPhase() {
        return this.actionPhase;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setSplitInfo(SplitMergeInfo splitInfo) {
        this.splitInfo = splitInfo;
    }

    public void setPrepareTransaction(Transaction prepareTransaction) {
        this.prepareTransaction = prepareTransaction;
    }

    public void setStoragePhase(StoragePhase storagePhase) {
        this.storagePhase = storagePhase;
    }

    public void setCreditPhase(CreditPhase creditPhase) {
        this.creditPhase = creditPhase;
    }

    public void setComputePhase(ComputePhase computePhase) {
        this.computePhase = computePhase;
    }

    public void setActionPhase(ActionPhase actionPhase) {
        this.actionPhase = actionPhase;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionDescriptionMergeInstall)) {
            return false;
        }
        TransactionDescriptionMergeInstall other = (TransactionDescriptionMergeInstall)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.isAborted() != other.isAborted()) {
            return false;
        }
        if (this.isDestroyed() != other.isDestroyed()) {
            return false;
        }
        SplitMergeInfo this$splitInfo = this.getSplitInfo();
        SplitMergeInfo other$splitInfo = other.getSplitInfo();
        if (this$splitInfo == null ? other$splitInfo != null : !((Object)this$splitInfo).equals(other$splitInfo)) {
            return false;
        }
        Transaction this$prepareTransaction = this.getPrepareTransaction();
        Transaction other$prepareTransaction = other.getPrepareTransaction();
        if (this$prepareTransaction == null ? other$prepareTransaction != null : !((Object)this$prepareTransaction).equals(other$prepareTransaction)) {
            return false;
        }
        StoragePhase this$storagePhase = this.getStoragePhase();
        StoragePhase other$storagePhase = other.getStoragePhase();
        if (this$storagePhase == null ? other$storagePhase != null : !((Object)this$storagePhase).equals(other$storagePhase)) {
            return false;
        }
        CreditPhase this$creditPhase = this.getCreditPhase();
        CreditPhase other$creditPhase = other.getCreditPhase();
        if (this$creditPhase == null ? other$creditPhase != null : !((Object)this$creditPhase).equals(other$creditPhase)) {
            return false;
        }
        ComputePhase this$computePhase = this.getComputePhase();
        ComputePhase other$computePhase = other.getComputePhase();
        if (this$computePhase == null ? other$computePhase != null : !this$computePhase.equals(other$computePhase)) {
            return false;
        }
        ActionPhase this$actionPhase = this.getActionPhase();
        ActionPhase other$actionPhase = other.getActionPhase();
        return !(this$actionPhase == null ? other$actionPhase != null : !((Object)this$actionPhase).equals(other$actionPhase));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionDescriptionMergeInstall;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        result = result * 59 + (this.isAborted() ? 79 : 97);
        result = result * 59 + (this.isDestroyed() ? 79 : 97);
        SplitMergeInfo $splitInfo = this.getSplitInfo();
        result = result * 59 + ($splitInfo == null ? 43 : ((Object)$splitInfo).hashCode());
        Transaction $prepareTransaction = this.getPrepareTransaction();
        result = result * 59 + ($prepareTransaction == null ? 43 : ((Object)$prepareTransaction).hashCode());
        StoragePhase $storagePhase = this.getStoragePhase();
        result = result * 59 + ($storagePhase == null ? 43 : ((Object)$storagePhase).hashCode());
        CreditPhase $creditPhase = this.getCreditPhase();
        result = result * 59 + ($creditPhase == null ? 43 : ((Object)$creditPhase).hashCode());
        ComputePhase $computePhase = this.getComputePhase();
        result = result * 59 + ($computePhase == null ? 43 : $computePhase.hashCode());
        ActionPhase $actionPhase = this.getActionPhase();
        result = result * 59 + ($actionPhase == null ? 43 : ((Object)$actionPhase).hashCode());
        return result;
    }

    public String toString() {
        return "TransactionDescriptionMergeInstall(magic=" + this.getMagic() + ", splitInfo=" + String.valueOf(this.getSplitInfo()) + ", prepareTransaction=" + String.valueOf(this.getPrepareTransaction()) + ", storagePhase=" + String.valueOf(this.getStoragePhase()) + ", creditPhase=" + String.valueOf(this.getCreditPhase()) + ", computePhase=" + String.valueOf(this.getComputePhase()) + ", actionPhase=" + String.valueOf(this.getActionPhase()) + ", aborted=" + this.isAborted() + ", destroyed=" + this.isDestroyed() + ")";
    }

    public static class TransactionDescriptionMergeInstallBuilder {
        private int magic;
        private SplitMergeInfo splitInfo;
        private Transaction prepareTransaction;
        private StoragePhase storagePhase;
        private CreditPhase creditPhase;
        private ComputePhase computePhase;
        private ActionPhase actionPhase;
        private boolean aborted;
        private boolean destroyed;

        TransactionDescriptionMergeInstallBuilder() {
        }

        public TransactionDescriptionMergeInstallBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public TransactionDescriptionMergeInstallBuilder splitInfo(SplitMergeInfo splitInfo) {
            this.splitInfo = splitInfo;
            return this;
        }

        public TransactionDescriptionMergeInstallBuilder prepareTransaction(Transaction prepareTransaction) {
            this.prepareTransaction = prepareTransaction;
            return this;
        }

        public TransactionDescriptionMergeInstallBuilder storagePhase(StoragePhase storagePhase) {
            this.storagePhase = storagePhase;
            return this;
        }

        public TransactionDescriptionMergeInstallBuilder creditPhase(CreditPhase creditPhase) {
            this.creditPhase = creditPhase;
            return this;
        }

        public TransactionDescriptionMergeInstallBuilder computePhase(ComputePhase computePhase) {
            this.computePhase = computePhase;
            return this;
        }

        public TransactionDescriptionMergeInstallBuilder actionPhase(ActionPhase actionPhase) {
            this.actionPhase = actionPhase;
            return this;
        }

        public TransactionDescriptionMergeInstallBuilder aborted(boolean aborted) {
            this.aborted = aborted;
            return this;
        }

        public TransactionDescriptionMergeInstallBuilder destroyed(boolean destroyed) {
            this.destroyed = destroyed;
            return this;
        }

        public TransactionDescriptionMergeInstall build() {
            return new TransactionDescriptionMergeInstall(this.magic, this.splitInfo, this.prepareTransaction, this.storagePhase, this.creditPhase, this.computePhase, this.actionPhase, this.aborted, this.destroyed);
        }

        public String toString() {
            return "TransactionDescriptionMergeInstall.TransactionDescriptionMergeInstallBuilder(magic=" + this.magic + ", splitInfo=" + String.valueOf(this.splitInfo) + ", prepareTransaction=" + String.valueOf(this.prepareTransaction) + ", storagePhase=" + String.valueOf(this.storagePhase) + ", creditPhase=" + String.valueOf(this.creditPhase) + ", computePhase=" + String.valueOf(this.computePhase) + ", actionPhase=" + String.valueOf(this.actionPhase) + ", aborted=" + this.aborted + ", destroyed=" + this.destroyed + ")";
        }
    }
}

