/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import org.ton.java.cell.Cell;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.TransactionDescriptionMergeInstall;
import org.ton.java.tlb.TransactionDescriptionMergePrepare;
import org.ton.java.tlb.TransactionDescriptionOrdinary;
import org.ton.java.tlb.TransactionDescriptionSplitInstall;
import org.ton.java.tlb.TransactionDescriptionSplitPrepare;
import org.ton.java.tlb.TransactionDescriptionStorage;
import org.ton.java.tlb.TransactionDescriptionTickTock;

public interface TransactionDescription {
    public Cell toCell();

    public static TransactionDescription deserialize(CellSlice cs) {
        int pfx = cs.preloadUint(3).intValue();
        switch (pfx) {
            case 0: {
                boolean isStorage = cs.preloadBit();
                if (isStorage) {
                    return TransactionDescriptionStorage.deserialize(cs);
                }
                return TransactionDescriptionOrdinary.deserialize(cs);
            }
            case 1: {
                return TransactionDescriptionTickTock.deserialize(cs);
            }
            case 2: {
                boolean isInstall = cs.preloadBit();
                if (isInstall) {
                    return TransactionDescriptionSplitInstall.deserialize(cs);
                }
                return TransactionDescriptionSplitPrepare.deserialize(cs);
            }
            case 3: {
                boolean isInstall = cs.preloadBit();
                if (isInstall) {
                    return TransactionDescriptionMergeInstall.deserialize(cs);
                }
                return TransactionDescriptionMergePrepare.deserialize(cs);
            }
        }
        throw new Error("unknown transaction description type (must be in range [0..3], found 0x" + Integer.toBinaryString(pfx));
    }

    public String getType();
}

