/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class StorageUsed
implements Serializable {
    BigInteger cellsUsed;
    BigInteger bitsUsed;

    public Cell toCell() {
        return CellBuilder.beginCell().storeVarUint(this.cellsUsed, 3).storeVarUint(this.bitsUsed, 3).endCell();
    }

    public static StorageUsed deserialize(CellSlice cs) {
        return StorageUsed.builder().cellsUsed(cs.loadVarUInteger(BigInteger.valueOf(3L))).bitsUsed(cs.loadVarUInteger(BigInteger.valueOf(3L))).build();
    }

    StorageUsed(BigInteger cellsUsed, BigInteger bitsUsed) {
        this.cellsUsed = cellsUsed;
        this.bitsUsed = bitsUsed;
    }

    public static StorageUsedBuilder builder() {
        return new StorageUsedBuilder();
    }

    public BigInteger getCellsUsed() {
        return this.cellsUsed;
    }

    public BigInteger getBitsUsed() {
        return this.bitsUsed;
    }

    public void setCellsUsed(BigInteger cellsUsed) {
        this.cellsUsed = cellsUsed;
    }

    public void setBitsUsed(BigInteger bitsUsed) {
        this.bitsUsed = bitsUsed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StorageUsed)) {
            return false;
        }
        StorageUsed other = (StorageUsed)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$cellsUsed = this.getCellsUsed();
        BigInteger other$cellsUsed = other.getCellsUsed();
        if (this$cellsUsed == null ? other$cellsUsed != null : !((Object)this$cellsUsed).equals(other$cellsUsed)) {
            return false;
        }
        BigInteger this$bitsUsed = this.getBitsUsed();
        BigInteger other$bitsUsed = other.getBitsUsed();
        return !(this$bitsUsed == null ? other$bitsUsed != null : !((Object)this$bitsUsed).equals(other$bitsUsed));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StorageUsed;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $cellsUsed = this.getCellsUsed();
        result = result * 59 + ($cellsUsed == null ? 43 : ((Object)$cellsUsed).hashCode());
        BigInteger $bitsUsed = this.getBitsUsed();
        result = result * 59 + ($bitsUsed == null ? 43 : ((Object)$bitsUsed).hashCode());
        return result;
    }

    public String toString() {
        return "StorageUsed(cellsUsed=" + String.valueOf(this.getCellsUsed()) + ", bitsUsed=" + String.valueOf(this.getBitsUsed()) + ")";
    }

    public static class StorageUsedBuilder {
        private BigInteger cellsUsed;
        private BigInteger bitsUsed;

        StorageUsedBuilder() {
        }

        public StorageUsedBuilder cellsUsed(BigInteger cellsUsed) {
            this.cellsUsed = cellsUsed;
            return this;
        }

        public StorageUsedBuilder bitsUsed(BigInteger bitsUsed) {
            this.bitsUsed = bitsUsed;
            return this;
        }

        public StorageUsed build() {
            return new StorageUsed(this.cellsUsed, this.bitsUsed);
        }

        public String toString() {
            return "StorageUsed.StorageUsedBuilder(cellsUsed=" + String.valueOf(this.cellsUsed) + ", bitsUsed=" + String.valueOf(this.bitsUsed) + ")";
        }
    }
}

