/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.AccStatusChange;

public class StoragePhase
implements Serializable {
    BigInteger storageFeesCollected;
    BigInteger storageFeesDue;
    AccStatusChange statusChange;

    public Cell toCell() {
        return CellBuilder.beginCell().storeCoins(this.storageFeesCollected).storeCoinsMaybe(this.storageFeesDue).storeSlice(CellSlice.beginParse((Cell)this.statusChange.toCell())).endCell();
    }

    public static StoragePhase deserialize(CellSlice cs) {
        return StoragePhase.builder().storageFeesCollected(cs.loadCoins()).storageFeesDue(cs.loadBit() ? cs.loadCoins() : null).statusChange(AccStatusChange.deserialize(cs)).build();
    }

    StoragePhase(BigInteger storageFeesCollected, BigInteger storageFeesDue, AccStatusChange statusChange) {
        this.storageFeesCollected = storageFeesCollected;
        this.storageFeesDue = storageFeesDue;
        this.statusChange = statusChange;
    }

    public static StoragePhaseBuilder builder() {
        return new StoragePhaseBuilder();
    }

    public BigInteger getStorageFeesCollected() {
        return this.storageFeesCollected;
    }

    public BigInteger getStorageFeesDue() {
        return this.storageFeesDue;
    }

    public AccStatusChange getStatusChange() {
        return this.statusChange;
    }

    public void setStorageFeesCollected(BigInteger storageFeesCollected) {
        this.storageFeesCollected = storageFeesCollected;
    }

    public void setStorageFeesDue(BigInteger storageFeesDue) {
        this.storageFeesDue = storageFeesDue;
    }

    public void setStatusChange(AccStatusChange statusChange) {
        this.statusChange = statusChange;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoragePhase)) {
            return false;
        }
        StoragePhase other = (StoragePhase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$storageFeesCollected = this.getStorageFeesCollected();
        BigInteger other$storageFeesCollected = other.getStorageFeesCollected();
        if (this$storageFeesCollected == null ? other$storageFeesCollected != null : !((Object)this$storageFeesCollected).equals(other$storageFeesCollected)) {
            return false;
        }
        BigInteger this$storageFeesDue = this.getStorageFeesDue();
        BigInteger other$storageFeesDue = other.getStorageFeesDue();
        if (this$storageFeesDue == null ? other$storageFeesDue != null : !((Object)this$storageFeesDue).equals(other$storageFeesDue)) {
            return false;
        }
        AccStatusChange this$statusChange = this.getStatusChange();
        AccStatusChange other$statusChange = other.getStatusChange();
        return !(this$statusChange == null ? other$statusChange != null : !((Object)this$statusChange).equals(other$statusChange));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StoragePhase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $storageFeesCollected = this.getStorageFeesCollected();
        result = result * 59 + ($storageFeesCollected == null ? 43 : ((Object)$storageFeesCollected).hashCode());
        BigInteger $storageFeesDue = this.getStorageFeesDue();
        result = result * 59 + ($storageFeesDue == null ? 43 : ((Object)$storageFeesDue).hashCode());
        AccStatusChange $statusChange = this.getStatusChange();
        result = result * 59 + ($statusChange == null ? 43 : ((Object)$statusChange).hashCode());
        return result;
    }

    public String toString() {
        return "StoragePhase(storageFeesCollected=" + String.valueOf(this.getStorageFeesCollected()) + ", storageFeesDue=" + String.valueOf(this.getStorageFeesDue()) + ", statusChange=" + String.valueOf(this.getStatusChange()) + ")";
    }

    public static class StoragePhaseBuilder {
        private BigInteger storageFeesCollected;
        private BigInteger storageFeesDue;
        private AccStatusChange statusChange;

        StoragePhaseBuilder() {
        }

        public StoragePhaseBuilder storageFeesCollected(BigInteger storageFeesCollected) {
            this.storageFeesCollected = storageFeesCollected;
            return this;
        }

        public StoragePhaseBuilder storageFeesDue(BigInteger storageFeesDue) {
            this.storageFeesDue = storageFeesDue;
            return this;
        }

        public StoragePhaseBuilder statusChange(AccStatusChange statusChange) {
            this.statusChange = statusChange;
            return this;
        }

        public StoragePhase build() {
            return new StoragePhase(this.storageFeesCollected, this.storageFeesDue, this.statusChange);
        }

        public String toString() {
            return "StoragePhase.StoragePhaseBuilder(storageFeesCollected=" + String.valueOf(this.storageFeesCollected) + ", storageFeesDue=" + String.valueOf(this.storageFeesDue) + ", statusChange=" + String.valueOf(this.statusChange) + ")";
        }
    }
}

