/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.TickTock;
import org.ton.java.utils.Utils;

public class StateInit
implements Serializable {
    BigInteger depth;
    TickTock tickTock;
    Cell code;
    Cell data;
    Cell lib;

    public Cell toCell() {
        CellBuilder result = CellBuilder.beginCell();
        if (Objects.nonNull(this.depth)) {
            result.storeBit(Boolean.valueOf(true));
            result.storeUint(this.depth, 5);
        } else {
            result.storeBit(Boolean.valueOf(false));
        }
        if (Objects.nonNull(this.tickTock)) {
            result.storeBit(Boolean.valueOf(true));
            result.storeCell(this.tickTock.toCell());
        } else {
            result.storeBit(Boolean.valueOf(false));
        }
        result.storeRefMaybe(this.code);
        result.storeRefMaybe(this.data);
        result.storeRefMaybe(this.lib);
        return result.endCell();
    }

    public static StateInit deserialize(CellSlice cs) {
        return StateInit.builder().depth(cs.loadBit() ? cs.loadUint(5) : null).tickTock(cs.loadBit() ? TickTock.deserialize(cs) : null).code(cs.loadMaybeRefX()).data(cs.loadMaybeRefX()).lib(cs.loadMaybeRefX()).build();
    }

    public Address getAddress(long wc) {
        return Address.of((String)(wc + ":" + Utils.bytesToHex((byte[])this.toCell().getHash())));
    }

    public Address getAddress() {
        return Address.of((String)("0:" + Utils.bytesToHex((byte[])this.toCell().getHash())));
    }

    StateInit(BigInteger depth, TickTock tickTock, Cell code, Cell data, Cell lib) {
        this.depth = depth;
        this.tickTock = tickTock;
        this.code = code;
        this.data = data;
        this.lib = lib;
    }

    public static StateInitBuilder builder() {
        return new StateInitBuilder();
    }

    public BigInteger getDepth() {
        return this.depth;
    }

    public TickTock getTickTock() {
        return this.tickTock;
    }

    public Cell getCode() {
        return this.code;
    }

    public Cell getData() {
        return this.data;
    }

    public Cell getLib() {
        return this.lib;
    }

    public void setDepth(BigInteger depth) {
        this.depth = depth;
    }

    public void setTickTock(TickTock tickTock) {
        this.tickTock = tickTock;
    }

    public void setCode(Cell code) {
        this.code = code;
    }

    public void setData(Cell data) {
        this.data = data;
    }

    public void setLib(Cell lib) {
        this.lib = lib;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateInit)) {
            return false;
        }
        StateInit other = (StateInit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$depth = this.getDepth();
        BigInteger other$depth = other.getDepth();
        if (this$depth == null ? other$depth != null : !((Object)this$depth).equals(other$depth)) {
            return false;
        }
        TickTock this$tickTock = this.getTickTock();
        TickTock other$tickTock = other.getTickTock();
        if (this$tickTock == null ? other$tickTock != null : !((Object)this$tickTock).equals(other$tickTock)) {
            return false;
        }
        Cell this$code = this.getCode();
        Cell other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        Cell this$data = this.getData();
        Cell other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Cell this$lib = this.getLib();
        Cell other$lib = other.getLib();
        return !(this$lib == null ? other$lib != null : !this$lib.equals(other$lib));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StateInit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $depth = this.getDepth();
        result = result * 59 + ($depth == null ? 43 : ((Object)$depth).hashCode());
        TickTock $tickTock = this.getTickTock();
        result = result * 59 + ($tickTock == null ? 43 : ((Object)$tickTock).hashCode());
        Cell $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        Cell $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Cell $lib = this.getLib();
        result = result * 59 + ($lib == null ? 43 : $lib.hashCode());
        return result;
    }

    public String toString() {
        return "StateInit(depth=" + String.valueOf(this.getDepth()) + ", tickTock=" + String.valueOf(this.getTickTock()) + ", code=" + String.valueOf(this.getCode()) + ", data=" + String.valueOf(this.getData()) + ", lib=" + String.valueOf(this.getLib()) + ")";
    }

    public static class StateInitBuilder {
        private BigInteger depth;
        private TickTock tickTock;
        private Cell code;
        private Cell data;
        private Cell lib;

        StateInitBuilder() {
        }

        public StateInitBuilder depth(BigInteger depth) {
            this.depth = depth;
            return this;
        }

        public StateInitBuilder tickTock(TickTock tickTock) {
            this.tickTock = tickTock;
            return this;
        }

        public StateInitBuilder code(Cell code) {
            this.code = code;
            return this;
        }

        public StateInitBuilder data(Cell data) {
            this.data = data;
            return this;
        }

        public StateInitBuilder lib(Cell lib) {
            this.lib = lib;
            return this;
        }

        public StateInit build() {
            return new StateInit(this.depth, this.tickTock, this.code, this.data, this.lib);
        }

        public String toString() {
            return "StateInit.StateInitBuilder(depth=" + String.valueOf(this.depth) + ", tickTock=" + String.valueOf(this.tickTock) + ", code=" + String.valueOf(this.code) + ", data=" + String.valueOf(this.data) + ", lib=" + String.valueOf(this.lib) + ")";
        }
    }
}

