/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class SplitMergeInfo
implements Serializable {
    int curShardPfxLen;
    int accSplitDepth;
    BigInteger thisAddr;
    BigInteger siblingAddr;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.curShardPfxLen, 6).storeUint(this.accSplitDepth, 6).storeUint(this.thisAddr, 256).storeUint(this.siblingAddr, 256).endCell();
    }

    public static SplitMergeInfo deserialize(CellSlice cs) {
        return SplitMergeInfo.builder().curShardPfxLen(cs.loadUint(6).intValue()).accSplitDepth(cs.loadUint(6).intValue()).thisAddr(cs.loadUint(256)).siblingAddr(cs.loadUint(256)).build();
    }

    SplitMergeInfo(int curShardPfxLen, int accSplitDepth, BigInteger thisAddr, BigInteger siblingAddr) {
        this.curShardPfxLen = curShardPfxLen;
        this.accSplitDepth = accSplitDepth;
        this.thisAddr = thisAddr;
        this.siblingAddr = siblingAddr;
    }

    public static SplitMergeInfoBuilder builder() {
        return new SplitMergeInfoBuilder();
    }

    public int getCurShardPfxLen() {
        return this.curShardPfxLen;
    }

    public int getAccSplitDepth() {
        return this.accSplitDepth;
    }

    public BigInteger getThisAddr() {
        return this.thisAddr;
    }

    public BigInteger getSiblingAddr() {
        return this.siblingAddr;
    }

    public void setCurShardPfxLen(int curShardPfxLen) {
        this.curShardPfxLen = curShardPfxLen;
    }

    public void setAccSplitDepth(int accSplitDepth) {
        this.accSplitDepth = accSplitDepth;
    }

    public void setThisAddr(BigInteger thisAddr) {
        this.thisAddr = thisAddr;
    }

    public void setSiblingAddr(BigInteger siblingAddr) {
        this.siblingAddr = siblingAddr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SplitMergeInfo)) {
            return false;
        }
        SplitMergeInfo other = (SplitMergeInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurShardPfxLen() != other.getCurShardPfxLen()) {
            return false;
        }
        if (this.getAccSplitDepth() != other.getAccSplitDepth()) {
            return false;
        }
        BigInteger this$thisAddr = this.getThisAddr();
        BigInteger other$thisAddr = other.getThisAddr();
        if (this$thisAddr == null ? other$thisAddr != null : !((Object)this$thisAddr).equals(other$thisAddr)) {
            return false;
        }
        BigInteger this$siblingAddr = this.getSiblingAddr();
        BigInteger other$siblingAddr = other.getSiblingAddr();
        return !(this$siblingAddr == null ? other$siblingAddr != null : !((Object)this$siblingAddr).equals(other$siblingAddr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SplitMergeInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurShardPfxLen();
        result = result * 59 + this.getAccSplitDepth();
        BigInteger $thisAddr = this.getThisAddr();
        result = result * 59 + ($thisAddr == null ? 43 : ((Object)$thisAddr).hashCode());
        BigInteger $siblingAddr = this.getSiblingAddr();
        result = result * 59 + ($siblingAddr == null ? 43 : ((Object)$siblingAddr).hashCode());
        return result;
    }

    public String toString() {
        return "SplitMergeInfo(curShardPfxLen=" + this.getCurShardPfxLen() + ", accSplitDepth=" + this.getAccSplitDepth() + ", thisAddr=" + String.valueOf(this.getThisAddr()) + ", siblingAddr=" + String.valueOf(this.getSiblingAddr()) + ")";
    }

    public static class SplitMergeInfoBuilder {
        private int curShardPfxLen;
        private int accSplitDepth;
        private BigInteger thisAddr;
        private BigInteger siblingAddr;

        SplitMergeInfoBuilder() {
        }

        public SplitMergeInfoBuilder curShardPfxLen(int curShardPfxLen) {
            this.curShardPfxLen = curShardPfxLen;
            return this;
        }

        public SplitMergeInfoBuilder accSplitDepth(int accSplitDepth) {
            this.accSplitDepth = accSplitDepth;
            return this;
        }

        public SplitMergeInfoBuilder thisAddr(BigInteger thisAddr) {
            this.thisAddr = thisAddr;
            return this;
        }

        public SplitMergeInfoBuilder siblingAddr(BigInteger siblingAddr) {
            this.siblingAddr = siblingAddr;
            return this;
        }

        public SplitMergeInfo build() {
            return new SplitMergeInfo(this.curShardPfxLen, this.accSplitDepth, this.thisAddr, this.siblingAddr);
        }

        public String toString() {
            return "SplitMergeInfo.SplitMergeInfoBuilder(curShardPfxLen=" + this.curShardPfxLen + ", accSplitDepth=" + this.accSplitDepth + ", thisAddr=" + String.valueOf(this.thisAddr) + ", siblingAddr=" + String.valueOf(this.siblingAddr) + ")";
        }
    }
}

