/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.SizeLimitsConfig;

public class SizeLimitsConfigV1
implements SizeLimitsConfig,
Serializable {
    int magic;
    long maxMsgBits;
    long maxMsgCells;
    long maxLibraryCells;
    int maxVmDataDepth;
    long maxExtMsgSize;
    int maxExtMsgDepth;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(1, 8).storeUint(this.maxMsgBits, 32).storeUint(this.maxMsgCells, 32).storeUint(this.maxLibraryCells, 32).storeUint(this.maxVmDataDepth, 16).storeUint(this.maxExtMsgSize, 32).storeUint(this.maxExtMsgDepth, 16).endCell();
    }

    public static SizeLimitsConfigV1 deserialize(CellSlice cs) {
        return SizeLimitsConfigV1.builder().magic(cs.loadUint(8).intValue()).maxMsgBits(cs.loadUint(32).longValue()).maxMsgCells(cs.loadUint(32).longValue()).maxLibraryCells(cs.loadUint(32).longValue()).maxVmDataDepth(cs.loadUint(32).intValue()).maxExtMsgSize(cs.loadUint(32).longValue()).maxExtMsgDepth(cs.loadUint(32).intValue()).build();
    }

    SizeLimitsConfigV1(int magic, long maxMsgBits, long maxMsgCells, long maxLibraryCells, int maxVmDataDepth, long maxExtMsgSize, int maxExtMsgDepth) {
        this.magic = magic;
        this.maxMsgBits = maxMsgBits;
        this.maxMsgCells = maxMsgCells;
        this.maxLibraryCells = maxLibraryCells;
        this.maxVmDataDepth = maxVmDataDepth;
        this.maxExtMsgSize = maxExtMsgSize;
        this.maxExtMsgDepth = maxExtMsgDepth;
    }

    public static SizeLimitsConfigV1Builder builder() {
        return new SizeLimitsConfigV1Builder();
    }

    public int getMagic() {
        return this.magic;
    }

    public long getMaxMsgBits() {
        return this.maxMsgBits;
    }

    public long getMaxMsgCells() {
        return this.maxMsgCells;
    }

    public long getMaxLibraryCells() {
        return this.maxLibraryCells;
    }

    public int getMaxVmDataDepth() {
        return this.maxVmDataDepth;
    }

    public long getMaxExtMsgSize() {
        return this.maxExtMsgSize;
    }

    public int getMaxExtMsgDepth() {
        return this.maxExtMsgDepth;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setMaxMsgBits(long maxMsgBits) {
        this.maxMsgBits = maxMsgBits;
    }

    public void setMaxMsgCells(long maxMsgCells) {
        this.maxMsgCells = maxMsgCells;
    }

    public void setMaxLibraryCells(long maxLibraryCells) {
        this.maxLibraryCells = maxLibraryCells;
    }

    public void setMaxVmDataDepth(int maxVmDataDepth) {
        this.maxVmDataDepth = maxVmDataDepth;
    }

    public void setMaxExtMsgSize(long maxExtMsgSize) {
        this.maxExtMsgSize = maxExtMsgSize;
    }

    public void setMaxExtMsgDepth(int maxExtMsgDepth) {
        this.maxExtMsgDepth = maxExtMsgDepth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SizeLimitsConfigV1)) {
            return false;
        }
        SizeLimitsConfigV1 other = (SizeLimitsConfigV1)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getMaxMsgBits() != other.getMaxMsgBits()) {
            return false;
        }
        if (this.getMaxMsgCells() != other.getMaxMsgCells()) {
            return false;
        }
        if (this.getMaxLibraryCells() != other.getMaxLibraryCells()) {
            return false;
        }
        if (this.getMaxVmDataDepth() != other.getMaxVmDataDepth()) {
            return false;
        }
        if (this.getMaxExtMsgSize() != other.getMaxExtMsgSize()) {
            return false;
        }
        return this.getMaxExtMsgDepth() == other.getMaxExtMsgDepth();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SizeLimitsConfigV1;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        long $maxMsgBits = this.getMaxMsgBits();
        result = result * 59 + (int)($maxMsgBits >>> 32 ^ $maxMsgBits);
        long $maxMsgCells = this.getMaxMsgCells();
        result = result * 59 + (int)($maxMsgCells >>> 32 ^ $maxMsgCells);
        long $maxLibraryCells = this.getMaxLibraryCells();
        result = result * 59 + (int)($maxLibraryCells >>> 32 ^ $maxLibraryCells);
        result = result * 59 + this.getMaxVmDataDepth();
        long $maxExtMsgSize = this.getMaxExtMsgSize();
        result = result * 59 + (int)($maxExtMsgSize >>> 32 ^ $maxExtMsgSize);
        result = result * 59 + this.getMaxExtMsgDepth();
        return result;
    }

    public String toString() {
        return "SizeLimitsConfigV1(magic=" + this.getMagic() + ", maxMsgBits=" + this.getMaxMsgBits() + ", maxMsgCells=" + this.getMaxMsgCells() + ", maxLibraryCells=" + this.getMaxLibraryCells() + ", maxVmDataDepth=" + this.getMaxVmDataDepth() + ", maxExtMsgSize=" + this.getMaxExtMsgSize() + ", maxExtMsgDepth=" + this.getMaxExtMsgDepth() + ")";
    }

    public static class SizeLimitsConfigV1Builder {
        private int magic;
        private long maxMsgBits;
        private long maxMsgCells;
        private long maxLibraryCells;
        private int maxVmDataDepth;
        private long maxExtMsgSize;
        private int maxExtMsgDepth;

        SizeLimitsConfigV1Builder() {
        }

        public SizeLimitsConfigV1Builder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public SizeLimitsConfigV1Builder maxMsgBits(long maxMsgBits) {
            this.maxMsgBits = maxMsgBits;
            return this;
        }

        public SizeLimitsConfigV1Builder maxMsgCells(long maxMsgCells) {
            this.maxMsgCells = maxMsgCells;
            return this;
        }

        public SizeLimitsConfigV1Builder maxLibraryCells(long maxLibraryCells) {
            this.maxLibraryCells = maxLibraryCells;
            return this;
        }

        public SizeLimitsConfigV1Builder maxVmDataDepth(int maxVmDataDepth) {
            this.maxVmDataDepth = maxVmDataDepth;
            return this;
        }

        public SizeLimitsConfigV1Builder maxExtMsgSize(long maxExtMsgSize) {
            this.maxExtMsgSize = maxExtMsgSize;
            return this;
        }

        public SizeLimitsConfigV1Builder maxExtMsgDepth(int maxExtMsgDepth) {
            this.maxExtMsgDepth = maxExtMsgDepth;
            return this;
        }

        public SizeLimitsConfigV1 build() {
            return new SizeLimitsConfigV1(this.magic, this.maxMsgBits, this.maxMsgCells, this.maxLibraryCells, this.maxVmDataDepth, this.maxExtMsgSize, this.maxExtMsgDepth);
        }

        public String toString() {
            return "SizeLimitsConfigV1.SizeLimitsConfigV1Builder(magic=" + this.magic + ", maxMsgBits=" + this.maxMsgBits + ", maxMsgCells=" + this.maxMsgCells + ", maxLibraryCells=" + this.maxLibraryCells + ", maxVmDataDepth=" + this.maxVmDataDepth + ", maxExtMsgSize=" + this.maxExtMsgSize + ", maxExtMsgDepth=" + this.maxExtMsgDepth + ")";
        }
    }
}

