/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.McStateExtra;
import org.ton.java.tlb.ShardIdent;
import org.ton.java.tlb.ShardStateInfo;

public class ShardStateUnsplit
implements Serializable {
    long magic;
    int globalId;
    ShardIdent shardIdent;
    long seqno;
    long vertSeqno;
    long genUTime;
    BigInteger genLt;
    long minRefMCSeqno;
    Cell outMsgQueueInfo;
    boolean beforeSplit;
    Cell shardAccounts;
    ShardStateInfo shardStateInfo;
    McStateExtra custom;

    private String getMagic() {
        return Long.toHexString(this.magic);
    }

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(-1876709406, 32).storeUint(this.globalId, 32).storeCell(this.shardIdent.toCell()).storeUint(this.seqno, 32).storeUint(this.vertSeqno, 32).storeUint(this.genUTime, 32).storeUint(this.genLt, 64).storeUint(this.minRefMCSeqno, 32).storeRef(this.outMsgQueueInfo).storeBit(Boolean.valueOf(this.beforeSplit)).storeRef(this.shardAccounts).storeRef(this.shardStateInfo.toCell()).storeRefMaybe(this.custom.toCell()).endCell();
    }

    public static ShardStateUnsplit deserialize(CellSlice cs) {
        if (cs.isExotic()) {
            return ShardStateUnsplit.builder().build();
        }
        long magic = cs.loadUint(32).longValue();
        assert (magic == 2418257890L) : "ShardStateUnsplit magic not equal to 0x9023afe2L, found 0x" + Long.toHexString(magic);
        ShardStateUnsplit shardStateUnsplit = ShardStateUnsplit.builder().magic(magic).globalId(cs.loadInt(32).intValue()).shardIdent(ShardIdent.deserialize(cs)).seqno(cs.loadUint(32).longValue()).vertSeqno(cs.loadUint(32).longValue()).genUTime(cs.loadUint(32).longValue()).genLt(cs.loadUint(64)).minRefMCSeqno(cs.loadUint(32).longValue()).outMsgQueueInfo(cs.loadRef()).build();
        shardStateUnsplit.setBeforeSplit(cs.loadBit());
        shardStateUnsplit.setShardAccounts(cs.loadRef());
        shardStateUnsplit.setShardStateInfo(ShardStateInfo.deserialize(CellSlice.beginParse((Cell)cs.loadRef())));
        shardStateUnsplit.setCustom(cs.loadBit() ? McStateExtra.deserialize(CellSlice.beginParse((Cell)cs.loadRef())) : null);
        return shardStateUnsplit;
    }

    ShardStateUnsplit(long magic, int globalId, ShardIdent shardIdent, long seqno, long vertSeqno, long genUTime, BigInteger genLt, long minRefMCSeqno, Cell outMsgQueueInfo, boolean beforeSplit, Cell shardAccounts, ShardStateInfo shardStateInfo, McStateExtra custom) {
        this.magic = magic;
        this.globalId = globalId;
        this.shardIdent = shardIdent;
        this.seqno = seqno;
        this.vertSeqno = vertSeqno;
        this.genUTime = genUTime;
        this.genLt = genLt;
        this.minRefMCSeqno = minRefMCSeqno;
        this.outMsgQueueInfo = outMsgQueueInfo;
        this.beforeSplit = beforeSplit;
        this.shardAccounts = shardAccounts;
        this.shardStateInfo = shardStateInfo;
        this.custom = custom;
    }

    public static ShardStateUnsplitBuilder builder() {
        return new ShardStateUnsplitBuilder();
    }

    public int getGlobalId() {
        return this.globalId;
    }

    public ShardIdent getShardIdent() {
        return this.shardIdent;
    }

    public long getSeqno() {
        return this.seqno;
    }

    public long getVertSeqno() {
        return this.vertSeqno;
    }

    public long getGenUTime() {
        return this.genUTime;
    }

    public BigInteger getGenLt() {
        return this.genLt;
    }

    public long getMinRefMCSeqno() {
        return this.minRefMCSeqno;
    }

    public Cell getOutMsgQueueInfo() {
        return this.outMsgQueueInfo;
    }

    public boolean isBeforeSplit() {
        return this.beforeSplit;
    }

    public Cell getShardAccounts() {
        return this.shardAccounts;
    }

    public ShardStateInfo getShardStateInfo() {
        return this.shardStateInfo;
    }

    public McStateExtra getCustom() {
        return this.custom;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setGlobalId(int globalId) {
        this.globalId = globalId;
    }

    public void setShardIdent(ShardIdent shardIdent) {
        this.shardIdent = shardIdent;
    }

    public void setSeqno(long seqno) {
        this.seqno = seqno;
    }

    public void setVertSeqno(long vertSeqno) {
        this.vertSeqno = vertSeqno;
    }

    public void setGenUTime(long genUTime) {
        this.genUTime = genUTime;
    }

    public void setGenLt(BigInteger genLt) {
        this.genLt = genLt;
    }

    public void setMinRefMCSeqno(long minRefMCSeqno) {
        this.minRefMCSeqno = minRefMCSeqno;
    }

    public void setOutMsgQueueInfo(Cell outMsgQueueInfo) {
        this.outMsgQueueInfo = outMsgQueueInfo;
    }

    public void setBeforeSplit(boolean beforeSplit) {
        this.beforeSplit = beforeSplit;
    }

    public void setShardAccounts(Cell shardAccounts) {
        this.shardAccounts = shardAccounts;
    }

    public void setShardStateInfo(ShardStateInfo shardStateInfo) {
        this.shardStateInfo = shardStateInfo;
    }

    public void setCustom(McStateExtra custom) {
        this.custom = custom;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardStateUnsplit)) {
            return false;
        }
        ShardStateUnsplit other = (ShardStateUnsplit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.getGlobalId() != other.getGlobalId()) {
            return false;
        }
        if (this.getSeqno() != other.getSeqno()) {
            return false;
        }
        if (this.getVertSeqno() != other.getVertSeqno()) {
            return false;
        }
        if (this.getGenUTime() != other.getGenUTime()) {
            return false;
        }
        if (this.getMinRefMCSeqno() != other.getMinRefMCSeqno()) {
            return false;
        }
        if (this.isBeforeSplit() != other.isBeforeSplit()) {
            return false;
        }
        ShardIdent this$shardIdent = this.getShardIdent();
        ShardIdent other$shardIdent = other.getShardIdent();
        if (this$shardIdent == null ? other$shardIdent != null : !((Object)this$shardIdent).equals(other$shardIdent)) {
            return false;
        }
        BigInteger this$genLt = this.getGenLt();
        BigInteger other$genLt = other.getGenLt();
        if (this$genLt == null ? other$genLt != null : !((Object)this$genLt).equals(other$genLt)) {
            return false;
        }
        Cell this$outMsgQueueInfo = this.getOutMsgQueueInfo();
        Cell other$outMsgQueueInfo = other.getOutMsgQueueInfo();
        if (this$outMsgQueueInfo == null ? other$outMsgQueueInfo != null : !this$outMsgQueueInfo.equals(other$outMsgQueueInfo)) {
            return false;
        }
        Cell this$shardAccounts = this.getShardAccounts();
        Cell other$shardAccounts = other.getShardAccounts();
        if (this$shardAccounts == null ? other$shardAccounts != null : !this$shardAccounts.equals(other$shardAccounts)) {
            return false;
        }
        ShardStateInfo this$shardStateInfo = this.getShardStateInfo();
        ShardStateInfo other$shardStateInfo = other.getShardStateInfo();
        if (this$shardStateInfo == null ? other$shardStateInfo != null : !((Object)this$shardStateInfo).equals(other$shardStateInfo)) {
            return false;
        }
        McStateExtra this$custom = this.getCustom();
        McStateExtra other$custom = other.getCustom();
        return !(this$custom == null ? other$custom != null : !((Object)this$custom).equals(other$custom));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardStateUnsplit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        result = result * 59 + this.getGlobalId();
        long $seqno = this.getSeqno();
        result = result * 59 + (int)($seqno >>> 32 ^ $seqno);
        long $vertSeqno = this.getVertSeqno();
        result = result * 59 + (int)($vertSeqno >>> 32 ^ $vertSeqno);
        long $genUTime = this.getGenUTime();
        result = result * 59 + (int)($genUTime >>> 32 ^ $genUTime);
        long $minRefMCSeqno = this.getMinRefMCSeqno();
        result = result * 59 + (int)($minRefMCSeqno >>> 32 ^ $minRefMCSeqno);
        result = result * 59 + (this.isBeforeSplit() ? 79 : 97);
        ShardIdent $shardIdent = this.getShardIdent();
        result = result * 59 + ($shardIdent == null ? 43 : ((Object)$shardIdent).hashCode());
        BigInteger $genLt = this.getGenLt();
        result = result * 59 + ($genLt == null ? 43 : ((Object)$genLt).hashCode());
        Cell $outMsgQueueInfo = this.getOutMsgQueueInfo();
        result = result * 59 + ($outMsgQueueInfo == null ? 43 : $outMsgQueueInfo.hashCode());
        Cell $shardAccounts = this.getShardAccounts();
        result = result * 59 + ($shardAccounts == null ? 43 : $shardAccounts.hashCode());
        ShardStateInfo $shardStateInfo = this.getShardStateInfo();
        result = result * 59 + ($shardStateInfo == null ? 43 : ((Object)$shardStateInfo).hashCode());
        McStateExtra $custom = this.getCustom();
        result = result * 59 + ($custom == null ? 43 : ((Object)$custom).hashCode());
        return result;
    }

    public String toString() {
        return "ShardStateUnsplit(magic=" + this.getMagic() + ", globalId=" + this.getGlobalId() + ", shardIdent=" + String.valueOf(this.getShardIdent()) + ", seqno=" + this.getSeqno() + ", vertSeqno=" + this.getVertSeqno() + ", genUTime=" + this.getGenUTime() + ", genLt=" + String.valueOf(this.getGenLt()) + ", minRefMCSeqno=" + this.getMinRefMCSeqno() + ", outMsgQueueInfo=" + String.valueOf(this.getOutMsgQueueInfo()) + ", beforeSplit=" + this.isBeforeSplit() + ", shardAccounts=" + String.valueOf(this.getShardAccounts()) + ", shardStateInfo=" + String.valueOf(this.getShardStateInfo()) + ", custom=" + String.valueOf(this.getCustom()) + ")";
    }

    public static class ShardStateUnsplitBuilder {
        private long magic;
        private int globalId;
        private ShardIdent shardIdent;
        private long seqno;
        private long vertSeqno;
        private long genUTime;
        private BigInteger genLt;
        private long minRefMCSeqno;
        private Cell outMsgQueueInfo;
        private boolean beforeSplit;
        private Cell shardAccounts;
        private ShardStateInfo shardStateInfo;
        private McStateExtra custom;

        ShardStateUnsplitBuilder() {
        }

        public ShardStateUnsplitBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public ShardStateUnsplitBuilder globalId(int globalId) {
            this.globalId = globalId;
            return this;
        }

        public ShardStateUnsplitBuilder shardIdent(ShardIdent shardIdent) {
            this.shardIdent = shardIdent;
            return this;
        }

        public ShardStateUnsplitBuilder seqno(long seqno) {
            this.seqno = seqno;
            return this;
        }

        public ShardStateUnsplitBuilder vertSeqno(long vertSeqno) {
            this.vertSeqno = vertSeqno;
            return this;
        }

        public ShardStateUnsplitBuilder genUTime(long genUTime) {
            this.genUTime = genUTime;
            return this;
        }

        public ShardStateUnsplitBuilder genLt(BigInteger genLt) {
            this.genLt = genLt;
            return this;
        }

        public ShardStateUnsplitBuilder minRefMCSeqno(long minRefMCSeqno) {
            this.minRefMCSeqno = minRefMCSeqno;
            return this;
        }

        public ShardStateUnsplitBuilder outMsgQueueInfo(Cell outMsgQueueInfo) {
            this.outMsgQueueInfo = outMsgQueueInfo;
            return this;
        }

        public ShardStateUnsplitBuilder beforeSplit(boolean beforeSplit) {
            this.beforeSplit = beforeSplit;
            return this;
        }

        public ShardStateUnsplitBuilder shardAccounts(Cell shardAccounts) {
            this.shardAccounts = shardAccounts;
            return this;
        }

        public ShardStateUnsplitBuilder shardStateInfo(ShardStateInfo shardStateInfo) {
            this.shardStateInfo = shardStateInfo;
            return this;
        }

        public ShardStateUnsplitBuilder custom(McStateExtra custom) {
            this.custom = custom;
            return this;
        }

        public ShardStateUnsplit build() {
            return new ShardStateUnsplit(this.magic, this.globalId, this.shardIdent, this.seqno, this.vertSeqno, this.genUTime, this.genLt, this.minRefMCSeqno, this.outMsgQueueInfo, this.beforeSplit, this.shardAccounts, this.shardStateInfo, this.custom);
        }

        public String toString() {
            return "ShardStateUnsplit.ShardStateUnsplitBuilder(magic=" + this.magic + ", globalId=" + this.globalId + ", shardIdent=" + String.valueOf(this.shardIdent) + ", seqno=" + this.seqno + ", vertSeqno=" + this.vertSeqno + ", genUTime=" + this.genUTime + ", genLt=" + String.valueOf(this.genLt) + ", minRefMCSeqno=" + this.minRefMCSeqno + ", outMsgQueueInfo=" + String.valueOf(this.outMsgQueueInfo) + ", beforeSplit=" + this.beforeSplit + ", shardAccounts=" + String.valueOf(this.shardAccounts) + ", shardStateInfo=" + String.valueOf(this.shardStateInfo) + ", custom=" + String.valueOf(this.custom) + ")";
        }
    }
}

