/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.ExtBlkRef;
import org.ton.java.tlb.LibDescr;

public class ShardStateInfo
implements Serializable {
    BigInteger overloadHistory;
    BigInteger underloadHistory;
    CurrencyCollection totalBalance;
    CurrencyCollection totalValidatorFees;
    TonHashMapE libraries;
    ExtBlkRef masterRef;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.overloadHistory, 64).storeUint(this.underloadHistory, 64).storeCell(this.totalBalance.toCell()).storeCell(this.totalValidatorFees.toCell()).storeDict(this.libraries.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 256).endCell().getBits(), v -> CellBuilder.beginCell().storeCell(((LibDescr)v).toCell()).endCell())).storeCellMaybe(this.masterRef.toCell()).endCell();
    }

    public static ShardStateInfo deserialize(CellSlice cs) {
        if (!cs.isExotic()) {
            return ShardStateInfo.builder().overloadHistory(cs.loadUint(64)).underloadHistory(cs.loadUint(64)).totalBalance(CurrencyCollection.deserialize(cs)).totalValidatorFees(CurrencyCollection.deserialize(cs)).libraries(cs.loadDictE(256, k -> k.readInt(256), v -> LibDescr.deserialize(CellSlice.beginParse((Cell)v)))).masterRef(cs.loadBit() ? ExtBlkRef.deserialize(CellSlice.beginParse((Object)cs)) : null).build();
        }
        return ShardStateInfo.builder().build();
    }

    ShardStateInfo(BigInteger overloadHistory, BigInteger underloadHistory, CurrencyCollection totalBalance, CurrencyCollection totalValidatorFees, TonHashMapE libraries, ExtBlkRef masterRef) {
        this.overloadHistory = overloadHistory;
        this.underloadHistory = underloadHistory;
        this.totalBalance = totalBalance;
        this.totalValidatorFees = totalValidatorFees;
        this.libraries = libraries;
        this.masterRef = masterRef;
    }

    public static ShardStateInfoBuilder builder() {
        return new ShardStateInfoBuilder();
    }

    public BigInteger getOverloadHistory() {
        return this.overloadHistory;
    }

    public BigInteger getUnderloadHistory() {
        return this.underloadHistory;
    }

    public CurrencyCollection getTotalBalance() {
        return this.totalBalance;
    }

    public CurrencyCollection getTotalValidatorFees() {
        return this.totalValidatorFees;
    }

    public TonHashMapE getLibraries() {
        return this.libraries;
    }

    public ExtBlkRef getMasterRef() {
        return this.masterRef;
    }

    public void setOverloadHistory(BigInteger overloadHistory) {
        this.overloadHistory = overloadHistory;
    }

    public void setUnderloadHistory(BigInteger underloadHistory) {
        this.underloadHistory = underloadHistory;
    }

    public void setTotalBalance(CurrencyCollection totalBalance) {
        this.totalBalance = totalBalance;
    }

    public void setTotalValidatorFees(CurrencyCollection totalValidatorFees) {
        this.totalValidatorFees = totalValidatorFees;
    }

    public void setLibraries(TonHashMapE libraries) {
        this.libraries = libraries;
    }

    public void setMasterRef(ExtBlkRef masterRef) {
        this.masterRef = masterRef;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardStateInfo)) {
            return false;
        }
        ShardStateInfo other = (ShardStateInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$overloadHistory = this.getOverloadHistory();
        BigInteger other$overloadHistory = other.getOverloadHistory();
        if (this$overloadHistory == null ? other$overloadHistory != null : !((Object)this$overloadHistory).equals(other$overloadHistory)) {
            return false;
        }
        BigInteger this$underloadHistory = this.getUnderloadHistory();
        BigInteger other$underloadHistory = other.getUnderloadHistory();
        if (this$underloadHistory == null ? other$underloadHistory != null : !((Object)this$underloadHistory).equals(other$underloadHistory)) {
            return false;
        }
        CurrencyCollection this$totalBalance = this.getTotalBalance();
        CurrencyCollection other$totalBalance = other.getTotalBalance();
        if (this$totalBalance == null ? other$totalBalance != null : !((Object)this$totalBalance).equals(other$totalBalance)) {
            return false;
        }
        CurrencyCollection this$totalValidatorFees = this.getTotalValidatorFees();
        CurrencyCollection other$totalValidatorFees = other.getTotalValidatorFees();
        if (this$totalValidatorFees == null ? other$totalValidatorFees != null : !((Object)this$totalValidatorFees).equals(other$totalValidatorFees)) {
            return false;
        }
        TonHashMapE this$libraries = this.getLibraries();
        TonHashMapE other$libraries = other.getLibraries();
        if (this$libraries == null ? other$libraries != null : !this$libraries.equals(other$libraries)) {
            return false;
        }
        ExtBlkRef this$masterRef = this.getMasterRef();
        ExtBlkRef other$masterRef = other.getMasterRef();
        return !(this$masterRef == null ? other$masterRef != null : !((Object)this$masterRef).equals(other$masterRef));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardStateInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $overloadHistory = this.getOverloadHistory();
        result = result * 59 + ($overloadHistory == null ? 43 : ((Object)$overloadHistory).hashCode());
        BigInteger $underloadHistory = this.getUnderloadHistory();
        result = result * 59 + ($underloadHistory == null ? 43 : ((Object)$underloadHistory).hashCode());
        CurrencyCollection $totalBalance = this.getTotalBalance();
        result = result * 59 + ($totalBalance == null ? 43 : ((Object)$totalBalance).hashCode());
        CurrencyCollection $totalValidatorFees = this.getTotalValidatorFees();
        result = result * 59 + ($totalValidatorFees == null ? 43 : ((Object)$totalValidatorFees).hashCode());
        TonHashMapE $libraries = this.getLibraries();
        result = result * 59 + ($libraries == null ? 43 : $libraries.hashCode());
        ExtBlkRef $masterRef = this.getMasterRef();
        result = result * 59 + ($masterRef == null ? 43 : ((Object)$masterRef).hashCode());
        return result;
    }

    public String toString() {
        return "ShardStateInfo(overloadHistory=" + String.valueOf(this.getOverloadHistory()) + ", underloadHistory=" + String.valueOf(this.getUnderloadHistory()) + ", totalBalance=" + String.valueOf(this.getTotalBalance()) + ", totalValidatorFees=" + String.valueOf(this.getTotalValidatorFees()) + ", libraries=" + String.valueOf(this.getLibraries()) + ", masterRef=" + String.valueOf(this.getMasterRef()) + ")";
    }

    public static class ShardStateInfoBuilder {
        private BigInteger overloadHistory;
        private BigInteger underloadHistory;
        private CurrencyCollection totalBalance;
        private CurrencyCollection totalValidatorFees;
        private TonHashMapE libraries;
        private ExtBlkRef masterRef;

        ShardStateInfoBuilder() {
        }

        public ShardStateInfoBuilder overloadHistory(BigInteger overloadHistory) {
            this.overloadHistory = overloadHistory;
            return this;
        }

        public ShardStateInfoBuilder underloadHistory(BigInteger underloadHistory) {
            this.underloadHistory = underloadHistory;
            return this;
        }

        public ShardStateInfoBuilder totalBalance(CurrencyCollection totalBalance) {
            this.totalBalance = totalBalance;
            return this;
        }

        public ShardStateInfoBuilder totalValidatorFees(CurrencyCollection totalValidatorFees) {
            this.totalValidatorFees = totalValidatorFees;
            return this;
        }

        public ShardStateInfoBuilder libraries(TonHashMapE libraries) {
            this.libraries = libraries;
            return this;
        }

        public ShardStateInfoBuilder masterRef(ExtBlkRef masterRef) {
            this.masterRef = masterRef;
            return this;
        }

        public ShardStateInfo build() {
            return new ShardStateInfo(this.overloadHistory, this.underloadHistory, this.totalBalance, this.totalValidatorFees, this.libraries, this.masterRef);
        }

        public String toString() {
            return "ShardStateInfo.ShardStateInfoBuilder(overloadHistory=" + String.valueOf(this.overloadHistory) + ", underloadHistory=" + String.valueOf(this.underloadHistory) + ", totalBalance=" + String.valueOf(this.totalBalance) + ", totalValidatorFees=" + String.valueOf(this.totalValidatorFees) + ", libraries=" + String.valueOf(this.libraries) + ", masterRef=" + String.valueOf(this.masterRef) + ")";
        }
    }
}

