/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class PrecompiledSmc
implements Serializable {
    int magic;
    BigInteger gasUsage;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(176, 8).storeUint(this.gasUsage, 64).endCell();
    }

    public static PrecompiledSmc deserialize(CellSlice cs) {
        return PrecompiledSmc.builder().magic(cs.loadUint(8).intValue()).gasUsage(cs.loadUint(64)).build();
    }

    PrecompiledSmc(int magic, BigInteger gasUsage) {
        this.magic = magic;
        this.gasUsage = gasUsage;
    }

    public static PrecompiledSmcBuilder builder() {
        return new PrecompiledSmcBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public BigInteger getGasUsage() {
        return this.gasUsage;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setGasUsage(BigInteger gasUsage) {
        this.gasUsage = gasUsage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrecompiledSmc)) {
            return false;
        }
        PrecompiledSmc other = (PrecompiledSmc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        BigInteger this$gasUsage = this.getGasUsage();
        BigInteger other$gasUsage = other.getGasUsage();
        return !(this$gasUsage == null ? other$gasUsage != null : !((Object)this$gasUsage).equals(other$gasUsage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrecompiledSmc;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        BigInteger $gasUsage = this.getGasUsage();
        result = result * 59 + ($gasUsage == null ? 43 : ((Object)$gasUsage).hashCode());
        return result;
    }

    public String toString() {
        return "PrecompiledSmc(magic=" + this.getMagic() + ", gasUsage=" + String.valueOf(this.getGasUsage()) + ")";
    }

    public static class PrecompiledSmcBuilder {
        private int magic;
        private BigInteger gasUsage;

        PrecompiledSmcBuilder() {
        }

        public PrecompiledSmcBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public PrecompiledSmcBuilder gasUsage(BigInteger gasUsage) {
            this.gasUsage = gasUsage;
            return this;
        }

        public PrecompiledSmc build() {
            return new PrecompiledSmc(this.magic, this.gasUsage);
        }

        public String toString() {
            return "PrecompiledSmc.PrecompiledSmcBuilder(magic=" + this.magic + ", gasUsage=" + String.valueOf(this.gasUsage) + ")";
        }
    }
}

