/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class ParamLimits
implements Serializable {
    int magic;
    long underload;
    long softLimit;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(195, 8).storeUint(this.underload, 32).storeUint(this.softLimit, 32).endCell();
    }

    public static ParamLimits deserialize(CellSlice cs) {
        return ParamLimits.builder().magic(cs.loadUint(8).intValue()).underload(cs.loadUint(32).intValue()).softLimit(cs.loadUint(32).intValue()).build();
    }

    ParamLimits(int magic, long underload, long softLimit) {
        this.magic = magic;
        this.underload = underload;
        this.softLimit = softLimit;
    }

    public static ParamLimitsBuilder builder() {
        return new ParamLimitsBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public long getUnderload() {
        return this.underload;
    }

    public long getSoftLimit() {
        return this.softLimit;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setUnderload(long underload) {
        this.underload = underload;
    }

    public void setSoftLimit(long softLimit) {
        this.softLimit = softLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParamLimits)) {
            return false;
        }
        ParamLimits other = (ParamLimits)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getUnderload() != other.getUnderload()) {
            return false;
        }
        return this.getSoftLimit() == other.getSoftLimit();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParamLimits;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        long $underload = this.getUnderload();
        result = result * 59 + (int)($underload >>> 32 ^ $underload);
        long $softLimit = this.getSoftLimit();
        result = result * 59 + (int)($softLimit >>> 32 ^ $softLimit);
        return result;
    }

    public String toString() {
        return "ParamLimits(magic=" + this.getMagic() + ", underload=" + this.getUnderload() + ", softLimit=" + this.getSoftLimit() + ")";
    }

    public static class ParamLimitsBuilder {
        private int magic;
        private long underload;
        private long softLimit;

        ParamLimitsBuilder() {
        }

        public ParamLimitsBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public ParamLimitsBuilder underload(long underload) {
            this.underload = underload;
            return this;
        }

        public ParamLimitsBuilder softLimit(long softLimit) {
            this.softLimit = softLimit;
            return this;
        }

        public ParamLimits build() {
            return new ParamLimits(this.magic, this.underload, this.softLimit);
        }

        public String toString() {
            return "ParamLimits.ParamLimitsBuilder(magic=" + this.magic + ", underload=" + this.underload + ", softLimit=" + this.softLimit + ")";
        }
    }
}

