/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import org.ton.java.cell.Cell;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.InMsg;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MsgEnvelope;
import org.ton.java.tlb.OutMsgDeq;
import org.ton.java.tlb.OutMsgDeqImm;
import org.ton.java.tlb.OutMsgDeqShort;
import org.ton.java.tlb.OutMsgExt;
import org.ton.java.tlb.OutMsgImm;
import org.ton.java.tlb.OutMsgNew;
import org.ton.java.tlb.OutMsgTr;
import org.ton.java.tlb.OutMsgTrReq;
import org.ton.java.tlb.Transaction;

public interface OutMsg {
    public Cell toCell();

    public static OutMsg deserialize(CellSlice cs) {
        int outMsgFlag = cs.loadUint(3).intValue();
        switch (outMsgFlag) {
            case 0: {
                return OutMsgExt.builder().msg(Message.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).transaction(Transaction.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).build();
            }
            case 2: {
                return OutMsgImm.builder().msg(MsgEnvelope.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).transaction(Transaction.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).reimport(InMsg.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).build();
            }
            case 1: {
                return OutMsgNew.builder().outMsg(MsgEnvelope.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).transaction(Transaction.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).build();
            }
            case 3: {
                return OutMsgTr.builder().outMsg(MsgEnvelope.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).imported(InMsg.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).build();
            }
            case 7: {
                return OutMsgTrReq.builder().msg(MsgEnvelope.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).imported(InMsg.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).build();
            }
            case 4: {
                return OutMsgDeqImm.builder().msg(MsgEnvelope.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).reimport(InMsg.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).build();
            }
            case 6: {
                boolean outMsgSubFlag = cs.loadBit();
                if (outMsgSubFlag) {
                    return OutMsgDeqShort.builder().msgEnvHash(cs.loadUint(256)).nextWorkchain(cs.loadInt(32).longValue()).nextAddrPfx(cs.loadUint(64)).importBlockLt(cs.loadUint(64)).build();
                }
                return OutMsgDeq.builder().outMsg(MsgEnvelope.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).importBlockLt(cs.loadUint(63)).build();
            }
        }
        throw new Error("unknown out_msg flag, found 0x" + Long.toBinaryString(outMsgFlag));
    }
}

