/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.OutAction;

public class OutList
implements Serializable {
    List<OutAction> actions;

    public Cell toCell() {
        if (Objects.isNull(this.actions)) {
            return null;
        }
        Cell list = CellBuilder.beginCell().endCell();
        for (OutAction action : this.actions) {
            Cell outAction = action.toCell();
            list = CellBuilder.beginCell().storeRef(list).storeCell(outAction).endCell();
        }
        return list;
    }

    public static OutList deserialize(CellSlice cs) {
        ArrayList<OutAction> actions = new ArrayList<OutAction>();
        while (cs.getRefsCount() != 0) {
            Cell t = cs.loadRef();
            actions.add(OutAction.deserialize(CellSlice.beginParse((Object)cs)));
            cs = CellSlice.beginParse((Cell)t);
        }
        return OutList.builder().actions(actions).build();
    }

    OutList(List<OutAction> actions) {
        this.actions = actions;
    }

    public static OutListBuilder builder() {
        return new OutListBuilder();
    }

    public List<OutAction> getActions() {
        return this.actions;
    }

    public void setActions(List<OutAction> actions) {
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutList)) {
            return false;
        }
        OutList other = (OutList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<OutAction> this$actions = this.getActions();
        List<OutAction> other$actions = other.getActions();
        return !(this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OutList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<OutAction> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        return result;
    }

    public String toString() {
        return "OutList(actions=" + String.valueOf(this.getActions()) + ")";
    }

    public static class OutListBuilder {
        private List<OutAction> actions;

        OutListBuilder() {
        }

        public OutListBuilder actions(List<OutAction> actions) {
            this.actions = actions;
            return this;
        }

        public OutList build() {
            return new OutList(this.actions);
        }

        public String toString() {
            return "OutList.OutListBuilder(actions=" + String.valueOf(this.actions) + ")";
        }
    }
}

