/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.IntermediateAddress;
import org.ton.java.tlb.Message;

public class MsgEnvelope
implements Serializable {
    int magic;
    IntermediateAddress currAddr;
    IntermediateAddress nextAddr;
    BigInteger fwdFeeRemaining;
    Message msg;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(4, 4).storeCell(this.currAddr.toCell()).storeCell(this.nextAddr.toCell()).storeCoins(this.fwdFeeRemaining).storeRef(this.msg.toCell()).endCell();
    }

    public static MsgEnvelope deserialize(CellSlice cs) {
        long magic = cs.loadUint(4).longValue();
        assert (magic == 4L) : "MsgEnvelope: magic not equal to 4, found 0x" + Long.toHexString(magic);
        return MsgEnvelope.builder().currAddr(IntermediateAddress.deserialize(cs)).nextAddr(IntermediateAddress.deserialize(cs)).fwdFeeRemaining(cs.loadCoins()).msg(Message.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).build();
    }

    MsgEnvelope(int magic, IntermediateAddress currAddr, IntermediateAddress nextAddr, BigInteger fwdFeeRemaining, Message msg) {
        this.magic = magic;
        this.currAddr = currAddr;
        this.nextAddr = nextAddr;
        this.fwdFeeRemaining = fwdFeeRemaining;
        this.msg = msg;
    }

    public static MsgEnvelopeBuilder builder() {
        return new MsgEnvelopeBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public IntermediateAddress getCurrAddr() {
        return this.currAddr;
    }

    public IntermediateAddress getNextAddr() {
        return this.nextAddr;
    }

    public BigInteger getFwdFeeRemaining() {
        return this.fwdFeeRemaining;
    }

    public Message getMsg() {
        return this.msg;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setCurrAddr(IntermediateAddress currAddr) {
        this.currAddr = currAddr;
    }

    public void setNextAddr(IntermediateAddress nextAddr) {
        this.nextAddr = nextAddr;
    }

    public void setFwdFeeRemaining(BigInteger fwdFeeRemaining) {
        this.fwdFeeRemaining = fwdFeeRemaining;
    }

    public void setMsg(Message msg) {
        this.msg = msg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MsgEnvelope)) {
            return false;
        }
        MsgEnvelope other = (MsgEnvelope)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        IntermediateAddress this$currAddr = this.getCurrAddr();
        IntermediateAddress other$currAddr = other.getCurrAddr();
        if (this$currAddr == null ? other$currAddr != null : !this$currAddr.equals(other$currAddr)) {
            return false;
        }
        IntermediateAddress this$nextAddr = this.getNextAddr();
        IntermediateAddress other$nextAddr = other.getNextAddr();
        if (this$nextAddr == null ? other$nextAddr != null : !this$nextAddr.equals(other$nextAddr)) {
            return false;
        }
        BigInteger this$fwdFeeRemaining = this.getFwdFeeRemaining();
        BigInteger other$fwdFeeRemaining = other.getFwdFeeRemaining();
        if (this$fwdFeeRemaining == null ? other$fwdFeeRemaining != null : !((Object)this$fwdFeeRemaining).equals(other$fwdFeeRemaining)) {
            return false;
        }
        Message this$msg = this.getMsg();
        Message other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !((Object)this$msg).equals(other$msg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MsgEnvelope;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        IntermediateAddress $currAddr = this.getCurrAddr();
        result = result * 59 + ($currAddr == null ? 43 : $currAddr.hashCode());
        IntermediateAddress $nextAddr = this.getNextAddr();
        result = result * 59 + ($nextAddr == null ? 43 : $nextAddr.hashCode());
        BigInteger $fwdFeeRemaining = this.getFwdFeeRemaining();
        result = result * 59 + ($fwdFeeRemaining == null ? 43 : ((Object)$fwdFeeRemaining).hashCode());
        Message $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : ((Object)$msg).hashCode());
        return result;
    }

    public String toString() {
        return "MsgEnvelope(magic=" + this.getMagic() + ", currAddr=" + String.valueOf(this.getCurrAddr()) + ", nextAddr=" + String.valueOf(this.getNextAddr()) + ", fwdFeeRemaining=" + String.valueOf(this.getFwdFeeRemaining()) + ", msg=" + String.valueOf(this.getMsg()) + ")";
    }

    public static class MsgEnvelopeBuilder {
        private int magic;
        private IntermediateAddress currAddr;
        private IntermediateAddress nextAddr;
        private BigInteger fwdFeeRemaining;
        private Message msg;

        MsgEnvelopeBuilder() {
        }

        public MsgEnvelopeBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public MsgEnvelopeBuilder currAddr(IntermediateAddress currAddr) {
            this.currAddr = currAddr;
            return this;
        }

        public MsgEnvelopeBuilder nextAddr(IntermediateAddress nextAddr) {
            this.nextAddr = nextAddr;
            return this;
        }

        public MsgEnvelopeBuilder fwdFeeRemaining(BigInteger fwdFeeRemaining) {
            this.fwdFeeRemaining = fwdFeeRemaining;
            return this;
        }

        public MsgEnvelopeBuilder msg(Message msg) {
            this.msg = msg;
            return this;
        }

        public MsgEnvelope build() {
            return new MsgEnvelope(this.magic, this.currAddr, this.nextAddr, this.fwdFeeRemaining, this.msg);
        }

        public String toString() {
            return "MsgEnvelope.MsgEnvelopeBuilder(magic=" + this.magic + ", currAddr=" + String.valueOf(this.currAddr) + ", nextAddr=" + String.valueOf(this.nextAddr) + ", fwdFeeRemaining=" + String.valueOf(this.fwdFeeRemaining) + ", msg=" + String.valueOf(this.msg) + ")";
        }
    }
}

