/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.Anycast;
import org.ton.java.tlb.MsgAddressInt;

public class MsgAddressIntVar
implements MsgAddressInt,
Serializable {
    int magic;
    Anycast anycast;
    int addrLen;
    int workchainId;
    BigInteger address;

    public String toString() {
        return Objects.nonNull(this.address) ? this.workchainId + ":" + this.address.toString(16) : null;
    }

    @Override
    public Cell toCell() {
        CellBuilder result = CellBuilder.beginCell();
        result.storeUint(3, 2);
        if (Objects.isNull(this.anycast)) {
            result.storeBit(Boolean.valueOf(false));
        } else {
            result.storeBit(Boolean.valueOf(true));
            result.storeCell(this.anycast.toCell());
        }
        result.storeUint(this.addrLen, 9).storeUint(this.workchainId, 32).storeUint(this.address, this.addrLen);
        return result.endCell();
    }

    public static MsgAddressIntVar deserialize(CellSlice cs) {
        int magic = cs.loadUint(2).intValue();
        assert (magic == 3) : "MsgAddressIntVar: magic not equal to 0b11, found " + magic;
        Anycast anycast = null;
        if (cs.loadBit()) {
            anycast = Anycast.deserialize(cs);
        }
        int addrLen = cs.loadUint(9).intValue();
        return MsgAddressIntVar.builder().magic(magic).anycast(anycast).addrLen(addrLen).workchainId(cs.loadUint(32).intValue()).address(cs.loadUint(addrLen)).build();
    }

    @Override
    public Address toAddress() {
        return Address.of((String)this.toString());
    }

    MsgAddressIntVar(int magic, Anycast anycast, int addrLen, int workchainId, BigInteger address) {
        this.magic = magic;
        this.anycast = anycast;
        this.addrLen = addrLen;
        this.workchainId = workchainId;
        this.address = address;
    }

    public static MsgAddressIntVarBuilder builder() {
        return new MsgAddressIntVarBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public Anycast getAnycast() {
        return this.anycast;
    }

    public int getAddrLen() {
        return this.addrLen;
    }

    public int getWorkchainId() {
        return this.workchainId;
    }

    public BigInteger getAddress() {
        return this.address;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setAnycast(Anycast anycast) {
        this.anycast = anycast;
    }

    public void setAddrLen(int addrLen) {
        this.addrLen = addrLen;
    }

    public void setWorkchainId(int workchainId) {
        this.workchainId = workchainId;
    }

    public void setAddress(BigInteger address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MsgAddressIntVar)) {
            return false;
        }
        MsgAddressIntVar other = (MsgAddressIntVar)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getAddrLen() != other.getAddrLen()) {
            return false;
        }
        if (this.getWorkchainId() != other.getWorkchainId()) {
            return false;
        }
        Anycast this$anycast = this.getAnycast();
        Anycast other$anycast = other.getAnycast();
        if (this$anycast == null ? other$anycast != null : !((Object)this$anycast).equals(other$anycast)) {
            return false;
        }
        BigInteger this$address = this.getAddress();
        BigInteger other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MsgAddressIntVar;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        result = result * 59 + this.getAddrLen();
        result = result * 59 + this.getWorkchainId();
        Anycast $anycast = this.getAnycast();
        result = result * 59 + ($anycast == null ? 43 : ((Object)$anycast).hashCode());
        BigInteger $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        return result;
    }

    public static class MsgAddressIntVarBuilder {
        private int magic;
        private Anycast anycast;
        private int addrLen;
        private int workchainId;
        private BigInteger address;

        MsgAddressIntVarBuilder() {
        }

        public MsgAddressIntVarBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public MsgAddressIntVarBuilder anycast(Anycast anycast) {
            this.anycast = anycast;
            return this;
        }

        public MsgAddressIntVarBuilder addrLen(int addrLen) {
            this.addrLen = addrLen;
            return this;
        }

        public MsgAddressIntVarBuilder workchainId(int workchainId) {
            this.workchainId = workchainId;
            return this;
        }

        public MsgAddressIntVarBuilder address(BigInteger address) {
            this.address = address;
            return this;
        }

        public MsgAddressIntVar build() {
            return new MsgAddressIntVar(this.magic, this.anycast, this.addrLen, this.workchainId, this.address);
        }

        public String toString() {
            return "MsgAddressIntVar.MsgAddressIntVarBuilder(magic=" + this.magic + ", anycast=" + String.valueOf(this.anycast) + ", addrLen=" + this.addrLen + ", workchainId=" + this.workchainId + ", address=" + String.valueOf(this.address) + ")";
        }
    }
}

