/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.MsgAddressExt;

public class MsgAddressExternal
implements MsgAddressExt,
Serializable {
    int magic;
    int len;
    public BigInteger externalAddress;

    @Override
    public String toString() {
        return Objects.nonNull(this.externalAddress) ? this.externalAddress.toString(16) : null;
    }

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(1, 2).storeUint(this.len, 9).storeUint(this.externalAddress, this.len).endCell();
    }

    public static MsgAddressExternal deserialize(CellSlice cs) {
        int magic = cs.loadUint(2).intValue();
        assert (magic == 1) : "MsgAddressExternal: magic not equal to 0b01, found " + magic;
        int len = cs.loadUint(9).intValue();
        BigInteger externalAddress = cs.loadUint(len);
        return MsgAddressExternal.builder().magic(magic).len(len).externalAddress(externalAddress).build();
    }

    MsgAddressExternal(int magic, int len, BigInteger externalAddress) {
        this.magic = magic;
        this.len = len;
        this.externalAddress = externalAddress;
    }

    public static MsgAddressExternalBuilder builder() {
        return new MsgAddressExternalBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public int getLen() {
        return this.len;
    }

    public BigInteger getExternalAddress() {
        return this.externalAddress;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public void setExternalAddress(BigInteger externalAddress) {
        this.externalAddress = externalAddress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MsgAddressExternal)) {
            return false;
        }
        MsgAddressExternal other = (MsgAddressExternal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getLen() != other.getLen()) {
            return false;
        }
        BigInteger this$externalAddress = this.getExternalAddress();
        BigInteger other$externalAddress = other.getExternalAddress();
        return !(this$externalAddress == null ? other$externalAddress != null : !((Object)this$externalAddress).equals(other$externalAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MsgAddressExternal;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        result = result * 59 + this.getLen();
        BigInteger $externalAddress = this.getExternalAddress();
        result = result * 59 + ($externalAddress == null ? 43 : ((Object)$externalAddress).hashCode());
        return result;
    }

    public static class MsgAddressExternalBuilder {
        private int magic;
        private int len;
        private BigInteger externalAddress;

        MsgAddressExternalBuilder() {
        }

        public MsgAddressExternalBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public MsgAddressExternalBuilder len(int len) {
            this.len = len;
            return this;
        }

        public MsgAddressExternalBuilder externalAddress(BigInteger externalAddress) {
            this.externalAddress = externalAddress;
            return this;
        }

        public MsgAddressExternal build() {
            return new MsgAddressExternal(this.magic, this.len, this.externalAddress);
        }

        public String toString() {
            return "MsgAddressExternal.MsgAddressExternalBuilder(magic=" + this.magic + ", len=" + this.len + ", externalAddress=" + String.valueOf(this.externalAddress) + ")";
        }
    }
}

