/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.CellType;
import org.ton.java.tlb.ShardState;

public class MerkleUpdate
implements Serializable {
    BigInteger oldHash;
    BigInteger newHash;
    BigInteger oldDepth;
    BigInteger newDepth;
    ShardState oldShardState;
    ShardState newShardState;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.oldHash, 256).storeUint(this.newHash, 256).storeUint(this.oldDepth, 16).storeUint(this.newDepth, 16).storeRef(this.oldShardState.toCell()).storeRef(this.newShardState.toCell()).endCell();
    }

    public static MerkleUpdate deserialize(CellSlice cs) {
        if (cs.type != CellType.MERKLE_UPDATE) {
            return null;
        }
        long magic = cs.loadUint(8).intValue();
        assert (magic == 4L) : "MerkleUpdate: magic not equal to 0x04, found 0x" + Long.toHexString(magic);
        return MerkleUpdate.builder().oldHash(cs.loadUint(256)).newHash(cs.loadUint(256)).oldDepth(cs.loadUint(16)).newDepth(cs.loadUint(16)).oldShardState(ShardState.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).newShardState(ShardState.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).build();
    }

    private String getOldHash() {
        return this.oldHash.toString(16);
    }

    private String getNewHash() {
        return this.newHash.toString(16);
    }

    MerkleUpdate(BigInteger oldHash, BigInteger newHash, BigInteger oldDepth, BigInteger newDepth, ShardState oldShardState, ShardState newShardState) {
        this.oldHash = oldHash;
        this.newHash = newHash;
        this.oldDepth = oldDepth;
        this.newDepth = newDepth;
        this.oldShardState = oldShardState;
        this.newShardState = newShardState;
    }

    public static MerkleUpdateBuilder builder() {
        return new MerkleUpdateBuilder();
    }

    public BigInteger getOldDepth() {
        return this.oldDepth;
    }

    public BigInteger getNewDepth() {
        return this.newDepth;
    }

    public ShardState getOldShardState() {
        return this.oldShardState;
    }

    public ShardState getNewShardState() {
        return this.newShardState;
    }

    public void setOldHash(BigInteger oldHash) {
        this.oldHash = oldHash;
    }

    public void setNewHash(BigInteger newHash) {
        this.newHash = newHash;
    }

    public void setOldDepth(BigInteger oldDepth) {
        this.oldDepth = oldDepth;
    }

    public void setNewDepth(BigInteger newDepth) {
        this.newDepth = newDepth;
    }

    public void setOldShardState(ShardState oldShardState) {
        this.oldShardState = oldShardState;
    }

    public void setNewShardState(ShardState newShardState) {
        this.newShardState = newShardState;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MerkleUpdate)) {
            return false;
        }
        MerkleUpdate other = (MerkleUpdate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$oldHash = this.getOldHash();
        String other$oldHash = other.getOldHash();
        if (this$oldHash == null ? other$oldHash != null : !this$oldHash.equals(other$oldHash)) {
            return false;
        }
        String this$newHash = this.getNewHash();
        String other$newHash = other.getNewHash();
        if (this$newHash == null ? other$newHash != null : !this$newHash.equals(other$newHash)) {
            return false;
        }
        BigInteger this$oldDepth = this.getOldDepth();
        BigInteger other$oldDepth = other.getOldDepth();
        if (this$oldDepth == null ? other$oldDepth != null : !((Object)this$oldDepth).equals(other$oldDepth)) {
            return false;
        }
        BigInteger this$newDepth = this.getNewDepth();
        BigInteger other$newDepth = other.getNewDepth();
        if (this$newDepth == null ? other$newDepth != null : !((Object)this$newDepth).equals(other$newDepth)) {
            return false;
        }
        ShardState this$oldShardState = this.getOldShardState();
        ShardState other$oldShardState = other.getOldShardState();
        if (this$oldShardState == null ? other$oldShardState != null : !((Object)this$oldShardState).equals(other$oldShardState)) {
            return false;
        }
        ShardState this$newShardState = this.getNewShardState();
        ShardState other$newShardState = other.getNewShardState();
        return !(this$newShardState == null ? other$newShardState != null : !((Object)this$newShardState).equals(other$newShardState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MerkleUpdate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldHash = this.getOldHash();
        result = result * 59 + ($oldHash == null ? 43 : $oldHash.hashCode());
        String $newHash = this.getNewHash();
        result = result * 59 + ($newHash == null ? 43 : $newHash.hashCode());
        BigInteger $oldDepth = this.getOldDepth();
        result = result * 59 + ($oldDepth == null ? 43 : ((Object)$oldDepth).hashCode());
        BigInteger $newDepth = this.getNewDepth();
        result = result * 59 + ($newDepth == null ? 43 : ((Object)$newDepth).hashCode());
        ShardState $oldShardState = this.getOldShardState();
        result = result * 59 + ($oldShardState == null ? 43 : ((Object)$oldShardState).hashCode());
        ShardState $newShardState = this.getNewShardState();
        result = result * 59 + ($newShardState == null ? 43 : ((Object)$newShardState).hashCode());
        return result;
    }

    public String toString() {
        return "MerkleUpdate(oldHash=" + this.getOldHash() + ", newHash=" + this.getNewHash() + ", oldDepth=" + String.valueOf(this.getOldDepth()) + ", newDepth=" + String.valueOf(this.getNewDepth()) + ", oldShardState=" + String.valueOf(this.getOldShardState()) + ", newShardState=" + String.valueOf(this.getNewShardState()) + ")";
    }

    public static class MerkleUpdateBuilder {
        private BigInteger oldHash;
        private BigInteger newHash;
        private BigInteger oldDepth;
        private BigInteger newDepth;
        private ShardState oldShardState;
        private ShardState newShardState;

        MerkleUpdateBuilder() {
        }

        public MerkleUpdateBuilder oldHash(BigInteger oldHash) {
            this.oldHash = oldHash;
            return this;
        }

        public MerkleUpdateBuilder newHash(BigInteger newHash) {
            this.newHash = newHash;
            return this;
        }

        public MerkleUpdateBuilder oldDepth(BigInteger oldDepth) {
            this.oldDepth = oldDepth;
            return this;
        }

        public MerkleUpdateBuilder newDepth(BigInteger newDepth) {
            this.newDepth = newDepth;
            return this;
        }

        public MerkleUpdateBuilder oldShardState(ShardState oldShardState) {
            this.oldShardState = oldShardState;
            return this;
        }

        public MerkleUpdateBuilder newShardState(ShardState newShardState) {
            this.newShardState = newShardState;
            return this;
        }

        public MerkleUpdate build() {
            return new MerkleUpdate(this.oldHash, this.newHash, this.oldDepth, this.newDepth, this.oldShardState, this.newShardState);
        }

        public String toString() {
            return "MerkleUpdate.MerkleUpdateBuilder(oldHash=" + String.valueOf(this.oldHash) + ", newHash=" + String.valueOf(this.newHash) + ", oldDepth=" + String.valueOf(this.oldDepth) + ", newDepth=" + String.valueOf(this.newDepth) + ", oldShardState=" + String.valueOf(this.oldShardState) + ", newShardState=" + String.valueOf(this.newShardState) + ")";
        }
    }
}

