/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMapAugE;
import org.ton.java.tlb.BlockCreateStats;
import org.ton.java.tlb.ExtBlkRef;
import org.ton.java.tlb.KeyExtBlkRef;
import org.ton.java.tlb.KeyMaxLt;
import org.ton.java.tlb.ValidatorInfo;

public class McStateExtraInfo
implements Serializable {
    BigInteger flags;
    ValidatorInfo validatorInfo;
    TonHashMapAugE prevBlocks;
    Boolean afterKeyBlock;
    ExtBlkRef lastKeyBlock;
    BlockCreateStats blockCreateStats;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.flags, 16).storeCell(this.validatorInfo.toCell()).storeDict(this.prevBlocks.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 32).endCell().getBits(), v -> CellBuilder.beginCell().storeCell(((KeyExtBlkRef)v).toCell()), e -> CellBuilder.beginCell().storeCell(((KeyMaxLt)e).toCell()), (fk, fv) -> CellBuilder.beginCell().storeUint(0, 1))).storeBit(this.afterKeyBlock).storeCellMaybe(this.lastKeyBlock.toCell()).storeCell(this.flags.testBit(0) ? this.blockCreateStats.toCell() : null).endCell();
    }

    public static McStateExtraInfo deserialize(CellSlice cs) {
        BigInteger flags = cs.preloadUint(16);
        if (flags.longValue() > 1L) {
            throw new Error("McStateExtra deserialization error expected flags <= 1, got: " + String.valueOf(flags));
        }
        McStateExtraInfo mcStateExtraInfo = McStateExtraInfo.builder().flags(cs.loadUint(16)).validatorInfo(ValidatorInfo.deserialize(cs)).prevBlocks(cs.loadDictAugE(32, k -> k.readInt(32), v -> v, e -> e)).afterKeyBlock(cs.loadBit()).build();
        cs.loadBits(65);
        mcStateExtraInfo.setLastKeyBlock(cs.loadBit() ? ExtBlkRef.deserialize(cs) : null);
        mcStateExtraInfo.setBlockCreateStats(flags.testBit(0) ? BlockCreateStats.deserialize(cs) : null);
        return mcStateExtraInfo;
    }

    public List<KeyExtBlkRef> getPrevBlocksAsList() {
        ArrayList<KeyExtBlkRef> prevBlock = new ArrayList<KeyExtBlkRef>();
        for (Map.Entry entry : this.prevBlocks.elements.entrySet()) {
            prevBlock.add((KeyExtBlkRef)((Pair)entry.getValue()).getLeft());
        }
        return prevBlock;
    }

    McStateExtraInfo(BigInteger flags, ValidatorInfo validatorInfo, TonHashMapAugE prevBlocks, Boolean afterKeyBlock, ExtBlkRef lastKeyBlock, BlockCreateStats blockCreateStats) {
        this.flags = flags;
        this.validatorInfo = validatorInfo;
        this.prevBlocks = prevBlocks;
        this.afterKeyBlock = afterKeyBlock;
        this.lastKeyBlock = lastKeyBlock;
        this.blockCreateStats = blockCreateStats;
    }

    public static McStateExtraInfoBuilder builder() {
        return new McStateExtraInfoBuilder();
    }

    public BigInteger getFlags() {
        return this.flags;
    }

    public ValidatorInfo getValidatorInfo() {
        return this.validatorInfo;
    }

    public TonHashMapAugE getPrevBlocks() {
        return this.prevBlocks;
    }

    public Boolean getAfterKeyBlock() {
        return this.afterKeyBlock;
    }

    public ExtBlkRef getLastKeyBlock() {
        return this.lastKeyBlock;
    }

    public BlockCreateStats getBlockCreateStats() {
        return this.blockCreateStats;
    }

    public void setFlags(BigInteger flags) {
        this.flags = flags;
    }

    public void setValidatorInfo(ValidatorInfo validatorInfo) {
        this.validatorInfo = validatorInfo;
    }

    public void setPrevBlocks(TonHashMapAugE prevBlocks) {
        this.prevBlocks = prevBlocks;
    }

    public void setAfterKeyBlock(Boolean afterKeyBlock) {
        this.afterKeyBlock = afterKeyBlock;
    }

    public void setLastKeyBlock(ExtBlkRef lastKeyBlock) {
        this.lastKeyBlock = lastKeyBlock;
    }

    public void setBlockCreateStats(BlockCreateStats blockCreateStats) {
        this.blockCreateStats = blockCreateStats;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McStateExtraInfo)) {
            return false;
        }
        McStateExtraInfo other = (McStateExtraInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$afterKeyBlock = this.getAfterKeyBlock();
        Boolean other$afterKeyBlock = other.getAfterKeyBlock();
        if (this$afterKeyBlock == null ? other$afterKeyBlock != null : !((Object)this$afterKeyBlock).equals(other$afterKeyBlock)) {
            return false;
        }
        BigInteger this$flags = this.getFlags();
        BigInteger other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        ValidatorInfo this$validatorInfo = this.getValidatorInfo();
        ValidatorInfo other$validatorInfo = other.getValidatorInfo();
        if (this$validatorInfo == null ? other$validatorInfo != null : !((Object)this$validatorInfo).equals(other$validatorInfo)) {
            return false;
        }
        TonHashMapAugE this$prevBlocks = this.getPrevBlocks();
        TonHashMapAugE other$prevBlocks = other.getPrevBlocks();
        if (this$prevBlocks == null ? other$prevBlocks != null : !this$prevBlocks.equals(other$prevBlocks)) {
            return false;
        }
        ExtBlkRef this$lastKeyBlock = this.getLastKeyBlock();
        ExtBlkRef other$lastKeyBlock = other.getLastKeyBlock();
        if (this$lastKeyBlock == null ? other$lastKeyBlock != null : !((Object)this$lastKeyBlock).equals(other$lastKeyBlock)) {
            return false;
        }
        BlockCreateStats this$blockCreateStats = this.getBlockCreateStats();
        BlockCreateStats other$blockCreateStats = other.getBlockCreateStats();
        return !(this$blockCreateStats == null ? other$blockCreateStats != null : !this$blockCreateStats.equals(other$blockCreateStats));
    }

    protected boolean canEqual(Object other) {
        return other instanceof McStateExtraInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $afterKeyBlock = this.getAfterKeyBlock();
        result = result * 59 + ($afterKeyBlock == null ? 43 : ((Object)$afterKeyBlock).hashCode());
        BigInteger $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        ValidatorInfo $validatorInfo = this.getValidatorInfo();
        result = result * 59 + ($validatorInfo == null ? 43 : ((Object)$validatorInfo).hashCode());
        TonHashMapAugE $prevBlocks = this.getPrevBlocks();
        result = result * 59 + ($prevBlocks == null ? 43 : $prevBlocks.hashCode());
        ExtBlkRef $lastKeyBlock = this.getLastKeyBlock();
        result = result * 59 + ($lastKeyBlock == null ? 43 : ((Object)$lastKeyBlock).hashCode());
        BlockCreateStats $blockCreateStats = this.getBlockCreateStats();
        result = result * 59 + ($blockCreateStats == null ? 43 : $blockCreateStats.hashCode());
        return result;
    }

    public String toString() {
        return "McStateExtraInfo(flags=" + String.valueOf(this.getFlags()) + ", validatorInfo=" + String.valueOf(this.getValidatorInfo()) + ", prevBlocks=" + String.valueOf(this.getPrevBlocks()) + ", afterKeyBlock=" + this.getAfterKeyBlock() + ", lastKeyBlock=" + String.valueOf(this.getLastKeyBlock()) + ", blockCreateStats=" + String.valueOf(this.getBlockCreateStats()) + ")";
    }

    public static class McStateExtraInfoBuilder {
        private BigInteger flags;
        private ValidatorInfo validatorInfo;
        private TonHashMapAugE prevBlocks;
        private Boolean afterKeyBlock;
        private ExtBlkRef lastKeyBlock;
        private BlockCreateStats blockCreateStats;

        McStateExtraInfoBuilder() {
        }

        public McStateExtraInfoBuilder flags(BigInteger flags) {
            this.flags = flags;
            return this;
        }

        public McStateExtraInfoBuilder validatorInfo(ValidatorInfo validatorInfo) {
            this.validatorInfo = validatorInfo;
            return this;
        }

        public McStateExtraInfoBuilder prevBlocks(TonHashMapAugE prevBlocks) {
            this.prevBlocks = prevBlocks;
            return this;
        }

        public McStateExtraInfoBuilder afterKeyBlock(Boolean afterKeyBlock) {
            this.afterKeyBlock = afterKeyBlock;
            return this;
        }

        public McStateExtraInfoBuilder lastKeyBlock(ExtBlkRef lastKeyBlock) {
            this.lastKeyBlock = lastKeyBlock;
            return this;
        }

        public McStateExtraInfoBuilder blockCreateStats(BlockCreateStats blockCreateStats) {
            this.blockCreateStats = blockCreateStats;
            return this;
        }

        public McStateExtraInfo build() {
            return new McStateExtraInfo(this.flags, this.validatorInfo, this.prevBlocks, this.afterKeyBlock, this.lastKeyBlock, this.blockCreateStats);
        }

        public String toString() {
            return "McStateExtraInfo.McStateExtraInfoBuilder(flags=" + String.valueOf(this.flags) + ", validatorInfo=" + String.valueOf(this.validatorInfo) + ", prevBlocks=" + String.valueOf(this.prevBlocks) + ", afterKeyBlock=" + this.afterKeyBlock + ", lastKeyBlock=" + String.valueOf(this.lastKeyBlock) + ", blockCreateStats=" + String.valueOf(this.blockCreateStats) + ")";
        }
    }
}

