/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMapAugE;
import org.ton.java.tlb.ConfigParams;
import org.ton.java.tlb.McBlockExtraInfo;
import org.ton.java.tlb.ShardHashes;

public class McBlockExtra
implements Serializable {
    long magic;
    boolean keyBlock;
    ShardHashes shardHashes;
    TonHashMapAugE shardFees;
    McBlockExtraInfo info;
    ConfigParams config;

    private String getMagic() {
        return Long.toHexString(this.magic);
    }

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(52389, 32).storeBit(Boolean.valueOf(this.keyBlock)).storeCell(this.shardHashes.toCell()).storeDict(this.shardFees.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 96).endCell().getBits(), v -> CellBuilder.beginCell().storeCell((Cell)v), e -> CellBuilder.beginCell().storeCell((Cell)e), (fk, fv) -> CellBuilder.beginCell().storeUint(0, 1))).storeRef(this.info.toCell()).storeCell(this.keyBlock ? this.config.toCell() : CellBuilder.beginCell().endCell()).endCell();
    }

    public static McBlockExtra deserialize(CellSlice cs) {
        long magic = cs.loadUint(16).longValue();
        assert (magic == 52389L) : "McBlockExtra: magic not equal to 0xcca5, found 0x" + Long.toHexString(magic);
        boolean keyBlock = cs.loadBit();
        McBlockExtra mcBlockExtra = McBlockExtra.builder().magic(52389L).keyBlock(keyBlock).shardHashes(ShardHashes.deserialize(cs)).shardFees(cs.loadDictAugE(96, k -> k.readInt(96), v -> v, e -> e)).build();
        mcBlockExtra.setInfo(McBlockExtraInfo.deserialize(CellSlice.beginParse((Cell)cs.loadRef())));
        mcBlockExtra.setConfig(keyBlock ? ConfigParams.deserialize(cs) : null);
        return mcBlockExtra;
    }

    McBlockExtra(long magic, boolean keyBlock, ShardHashes shardHashes, TonHashMapAugE shardFees, McBlockExtraInfo info, ConfigParams config) {
        this.magic = magic;
        this.keyBlock = keyBlock;
        this.shardHashes = shardHashes;
        this.shardFees = shardFees;
        this.info = info;
        this.config = config;
    }

    public static McBlockExtraBuilder builder() {
        return new McBlockExtraBuilder();
    }

    public boolean isKeyBlock() {
        return this.keyBlock;
    }

    public ShardHashes getShardHashes() {
        return this.shardHashes;
    }

    public TonHashMapAugE getShardFees() {
        return this.shardFees;
    }

    public McBlockExtraInfo getInfo() {
        return this.info;
    }

    public ConfigParams getConfig() {
        return this.config;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setKeyBlock(boolean keyBlock) {
        this.keyBlock = keyBlock;
    }

    public void setShardHashes(ShardHashes shardHashes) {
        this.shardHashes = shardHashes;
    }

    public void setShardFees(TonHashMapAugE shardFees) {
        this.shardFees = shardFees;
    }

    public void setInfo(McBlockExtraInfo info) {
        this.info = info;
    }

    public void setConfig(ConfigParams config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McBlockExtra)) {
            return false;
        }
        McBlockExtra other = (McBlockExtra)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.isKeyBlock() != other.isKeyBlock()) {
            return false;
        }
        ShardHashes this$shardHashes = this.getShardHashes();
        ShardHashes other$shardHashes = other.getShardHashes();
        if (this$shardHashes == null ? other$shardHashes != null : !((Object)this$shardHashes).equals(other$shardHashes)) {
            return false;
        }
        TonHashMapAugE this$shardFees = this.getShardFees();
        TonHashMapAugE other$shardFees = other.getShardFees();
        if (this$shardFees == null ? other$shardFees != null : !this$shardFees.equals(other$shardFees)) {
            return false;
        }
        McBlockExtraInfo this$info = this.getInfo();
        McBlockExtraInfo other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        ConfigParams this$config = this.getConfig();
        ConfigParams other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)this$config).equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof McBlockExtra;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        result = result * 59 + (this.isKeyBlock() ? 79 : 97);
        ShardHashes $shardHashes = this.getShardHashes();
        result = result * 59 + ($shardHashes == null ? 43 : ((Object)$shardHashes).hashCode());
        TonHashMapAugE $shardFees = this.getShardFees();
        result = result * 59 + ($shardFees == null ? 43 : $shardFees.hashCode());
        McBlockExtraInfo $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        ConfigParams $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        return result;
    }

    public String toString() {
        return "McBlockExtra(magic=" + this.getMagic() + ", keyBlock=" + this.isKeyBlock() + ", shardHashes=" + String.valueOf(this.getShardHashes()) + ", shardFees=" + String.valueOf(this.getShardFees()) + ", info=" + String.valueOf(this.getInfo()) + ", config=" + String.valueOf(this.getConfig()) + ")";
    }

    public static class McBlockExtraBuilder {
        private long magic;
        private boolean keyBlock;
        private ShardHashes shardHashes;
        private TonHashMapAugE shardFees;
        private McBlockExtraInfo info;
        private ConfigParams config;

        McBlockExtraBuilder() {
        }

        public McBlockExtraBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public McBlockExtraBuilder keyBlock(boolean keyBlock) {
            this.keyBlock = keyBlock;
            return this;
        }

        public McBlockExtraBuilder shardHashes(ShardHashes shardHashes) {
            this.shardHashes = shardHashes;
            return this;
        }

        public McBlockExtraBuilder shardFees(TonHashMapAugE shardFees) {
            this.shardFees = shardFees;
            return this;
        }

        public McBlockExtraBuilder info(McBlockExtraInfo info) {
            this.info = info;
            return this;
        }

        public McBlockExtraBuilder config(ConfigParams config) {
            this.config = config;
            return this;
        }

        public McBlockExtra build() {
            return new McBlockExtra(this.magic, this.keyBlock, this.shardHashes, this.shardFees, this.info, this.config);
        }

        public String toString() {
            return "McBlockExtra.McBlockExtraBuilder(magic=" + this.magic + ", keyBlock=" + this.keyBlock + ", shardHashes=" + String.valueOf(this.shardHashes) + ", shardFees=" + String.valueOf(this.shardFees) + ", info=" + String.valueOf(this.info) + ", config=" + String.valueOf(this.config) + ")";
        }
    }
}

